// Three.js r36 - http://github.com/mrdoob/three.js
var THREE=THREE||{};THREE.Color=function(a){this.setHex(a)};
THREE.Color.prototype={autoUpdate:!0,setRGB:function(a,c,b){this.r=a;this.g=c;this.b=b;if(this.autoUpdate){this.updateHex();this.updateStyleString()}},setHSV:function(a,c,b){var d,e,g,h,j,k;if(b==0)d=e=g=0;else{h=Math.floor(a*6);j=a*6-h;a=b*(1-c);k=b*(1-c*j);c=b*(1-c*(1-j));switch(h){case 1:d=k;e=b;g=a;break;case 2:d=a;e=b;g=c;break;case 3:d=a;e=k;g=b;break;case 4:d=c;e=a;g=b;break;case 5:d=b;e=a;g=k;break;case 6:case 0:d=b;e=c;g=a}}this.r=d;this.g=e;this.b=g;if(this.autoUpdate){this.updateHex();
this.updateStyleString()}},setHex:function(a){this.hex=~~a&16777215;if(this.autoUpdate){this.updateRGB();this.updateStyleString()}},updateHex:function(){this.hex=~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},updateRGB:function(){this.r=(this.hex>>16&255)/255;this.g=(this.hex>>8&255)/255;this.b=(this.hex&255)/255},updateStyleString:function(){this.__styleString="rgb("+~~(this.r*255)+","+~~(this.g*255)+","+~~(this.b*255)+")"},clone:function(){return new THREE.Color(this.hex)}};
THREE.Vector2=function(a,c){this.set(a||0,c||0)};
THREE.Vector2.prototype={set:function(a,c){this.x=a;this.y=c;return this},copy:function(a){this.set(a.x,a.y);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y);return this},add:function(a,c){this.set(a.x+c.x,a.y+c.y);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y);return this},sub:function(a,c){this.set(a.x-c.x,a.y-c.y);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a);return this},negate:function(){this.set(-this.x,-this.y);return this},unit:function(){this.multiplyScalar(1/
this.length());return this},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y},clone:function(){return new THREE.Vector2(this.x,this.y)}};THREE.Vector3=function(a,c,b){this.set(a||0,c||0,b||0)};
THREE.Vector3.prototype={set:function(a,c,b){this.x=a;this.y=c;this.z=b;return this},copy:function(a){this.set(a.x,a.y,a.z);return this},add:function(a,c){this.set(a.x+c.x,a.y+c.y,a.z+c.z);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z);return this},addScalar:function(a){this.set(this.x+a,this.y+a,this.z+a);return this},sub:function(a,c){this.set(a.x-c.x,a.y-c.y,a.z-c.z);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z);return this},cross:function(a,
c){this.set(a.y*c.z-a.z*c.y,a.z*c.x-a.x*c.z,a.x*c.y-a.y*c.x);return this},crossSelf:function(a){var c=this.x,b=this.y,d=this.z;this.set(b*a.z-d*a.y,d*a.x-c*a.z,c*a.y-b*a.x);return this},multiply:function(a,c){this.set(a.x*c.x,a.y*c.y,a.z*c.z);return this},multiplySelf:function(a){this.set(this.x*a.x,this.y*a.y,this.z*a.z);return this},multiplyScalar:function(a){this.set(this.x*a,this.y*a,this.z*a);return this},divideSelf:function(a){this.set(this.x/a.x,this.y/a.y,this.z/a.z);return this},divideScalar:function(a){this.set(this.x/
a,this.y/a,this.z/a);return this},negate:function(){this.set(-this.x,-this.y,-this.z);return this},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var c=this.x-a.x,b=this.y-a.y;a=this.z-a.z;return c*c+b*b+a*a},length:function(){return Math.sqrt(this.lengthSq())},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){var a=
this.length();a>0?this.multiplyScalar(1/a):this.set(0,0,0);return this},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){this.y=Math.asin(a.n13);var c=Math.cos(this.y);if(Math.abs(c)>1.0E-5){this.x=Math.atan2(-a.n23/c,a.n33/c);this.z=Math.atan2(-a.n13/c,a.n11/c)}else{this.x=0;this.z=Math.atan2(a.n21,a.n22)}},setLength:function(a){return this.normalize().multiplyScalar(a)},isZero:function(){return Math.abs(this.x)<1.0E-4&&Math.abs(this.y)<
1.0E-4&&Math.abs(this.z)<1.0E-4},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)}};THREE.Vector4=function(a,c,b,d){this.set(a||0,c||0,b||0,d||1)};
THREE.Vector4.prototype={set:function(a,c,b,d){this.x=a;this.y=c;this.z=b;this.w=d;return this},copy:function(a){this.set(a.x,a.y,a.z,a.w||1);return this},add:function(a,c){this.set(a.x+c.x,a.y+c.y,a.z+c.z,a.w+c.w);return this},addSelf:function(a){this.set(this.x+a.x,this.y+a.y,this.z+a.z,this.w+a.w);return this},sub:function(a,c){this.set(a.x-c.x,a.y-c.y,a.z-c.z,a.w-c.w);return this},subSelf:function(a){this.set(this.x-a.x,this.y-a.y,this.z-a.z,this.w-a.w);return this},multiplyScalar:function(a){this.set(this.x*
a,this.y*a,this.z*a,this.w*a);return this},divideScalar:function(a){this.set(this.x/a,this.y/a,this.z/a,this.w/a);return this},lerpSelf:function(a,c){this.set(this.x+(a.x-this.x)*c,this.y+(a.y-this.y)*c,this.z+(a.z-this.z)*c,this.w+(a.w-this.w)*c)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)}};THREE.Ray=function(a,c){this.origin=a||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={intersectScene:function(a){var c,b,d=a.objects,e=[];a=0;for(c=d.length;a<c;a++){b=d[a];b instanceof THREE.Mesh&&(e=e.concat(this.intersectObject(b)))}e.sort(function(g,h){return g.distance-h.distance});return e},intersectObject:function(a){function c(B,u,E,x){x=x.clone().subSelf(u);E=E.clone().subSelf(u);var M=B.clone().subSelf(u);B=x.dot(x);u=x.dot(E);x=x.dot(M);var I=E.dot(E);E=E.dot(M);M=1/(B*I-u*u);I=(I*x-u*E)*M;B=(B*E-u*x)*M;return I>0&&B>0&&I+B<1}var b,d,e,g,h,j,k,n,t,z,
v,o=a.geometry,w=o.vertices,y=[];b=0;for(d=o.faces.length;b<d;b++){e=o.faces[b];z=this.origin.clone();v=this.direction.clone();k=a.matrixWorld;g=k.multiplyVector3(w[e.a].position.clone());h=k.multiplyVector3(w[e.b].position.clone());j=k.multiplyVector3(w[e.c].position.clone());k=e instanceof THREE.Face4?k.multiplyVector3(w[e.d].position.clone()):null;n=a.matrixRotationWorld.multiplyVector3(e.normal.clone());t=v.dot(n);if(t<0){n=n.dot((new THREE.Vector3).sub(g,z))/t;z=z.addSelf(v.multiplyScalar(n));
if(e instanceof THREE.Face3){if(c(z,g,h,j)){e={distance:this.origin.distanceTo(z),point:z,face:e,object:a};y.push(e)}}else if(e instanceof THREE.Face4&&(c(z,g,h,k)||c(z,h,j,k))){e={distance:this.origin.distanceTo(z),point:z,face:e,object:a};y.push(e)}}}return y}};
THREE.Rectangle=function(){function a(){g=d-c;h=e-b}var c,b,d,e,g,h,j=!0;this.getX=function(){return c};this.getY=function(){return b};this.getWidth=function(){return g};this.getHeight=function(){return h};this.getLeft=function(){return c};this.getTop=function(){return b};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(k,n,t,z){j=!1;c=k;b=n;d=t;e=z;a()};this.addPoint=function(k,n){if(j){j=!1;c=k;b=n;d=k;e=n}else{c=c<k?c:k;b=b<n?b:n;d=d>k?d:k;e=e>n?e:n}a()};
this.add3Points=function(k,n,t,z,v,o){if(j){j=!1;c=k<t?k<v?k:v:t<v?t:v;b=n<z?n<o?n:o:z<o?z:o;d=k>t?k>v?k:v:t>v?t:v;e=n>z?n>o?n:o:z>o?z:o}else{c=k<t?k<v?k<c?k:c:v<c?v:c:t<v?t<c?t:c:v<c?v:c;b=n<z?n<o?n<b?n:b:o<b?o:b:z<o?z<b?z:b:o<b?o:b;d=k>t?k>v?k>d?k:d:v>d?v:d:t>v?t>d?t:d:v>d?v:d;e=n>z?n>o?n>e?n:e:o>e?o:e:z>o?z>e?z:e:o>e?o:e}a()};this.addRectangle=function(k){if(j){j=!1;c=k.getLeft();b=k.getTop();d=k.getRight();e=k.getBottom()}else{c=c<k.getLeft()?c:k.getLeft();b=b<k.getTop()?b:k.getTop();d=d>k.getRight()?
d:k.getRight();e=e>k.getBottom()?e:k.getBottom()}a()};this.inflate=function(k){c-=k;b-=k;d+=k;e+=k;a()};this.minSelf=function(k){c=c>k.getLeft()?c:k.getLeft();b=b>k.getTop()?b:k.getTop();d=d<k.getRight()?d:k.getRight();e=e<k.getBottom()?e:k.getBottom();a()};this.instersects=function(k){return Math.min(d,k.getRight())-Math.max(c,k.getLeft())>=0&&Math.min(e,k.getBottom())-Math.max(b,k.getTop())>=0};this.empty=function(){j=!0;e=d=b=c=0;a()};this.isEmpty=function(){return j}};
THREE.Matrix3=function(){this.m=[]};THREE.Matrix3.prototype={transpose:function(){var a,c=this.m;a=c[1];c[1]=c[3];c[3]=a;a=c[2];c[2]=c[6];c[6]=a;a=c[5];c[5]=c[7];c[7]=a;return this},transposeIntoArray:function(a){var c=this.m;a[0]=c[0];a[1]=c[3];a[2]=c[6];a[3]=c[1];a[4]=c[4];a[5]=c[7];a[6]=c[2];a[7]=c[5];a[8]=c[8];return this}};
THREE.Matrix4=function(a,c,b,d,e,g,h,j,k,n,t,z,v,o,w,y){this.set(a||1,c||0,b||0,d||0,e||0,g||1,h||0,j||0,k||0,n||0,t||1,z||0,v||0,o||0,w||0,y||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={set:function(a,c,b,d,e,g,h,j,k,n,t,z,v,o,w,y){this.n11=a;this.n12=c;this.n13=b;this.n14=d;this.n21=e;this.n22=g;this.n23=h;this.n24=j;this.n31=k;this.n32=n;this.n33=t;this.n34=z;this.n41=v;this.n42=o;this.n43=w;this.n44=y;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,c,b){var d=THREE.Matrix4.__v1,
e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,c).normalize();if(g.length()===0)g.z=1;d.cross(b,g).normalize();if(d.length()===0){g.x+=1.0E-4;d.cross(b,g).normalize()}e.cross(g,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=g.x;this.n21=d.y;this.n22=e.y;this.n23=g.y;this.n31=d.z;this.n32=e.z;this.n33=g.z;return this},multiplyVector3:function(a){var c=a.x,b=a.y,d=a.z,e=1/(this.n41*c+this.n42*b+this.n43*d+this.n44);a.x=(this.n11*c+this.n12*b+this.n13*d+this.n14)*e;a.y=(this.n21*c+this.n22*b+this.n23*
d+this.n24)*e;a.z=(this.n31*c+this.n32*b+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var c=a.x,b=a.y,d=a.z,e=a.w;a.x=this.n11*c+this.n12*b+this.n13*d+this.n14*e;a.y=this.n21*c+this.n22*b+this.n23*d+this.n24*e;a.z=this.n31*c+this.n32*b+this.n33*d+this.n34*e;a.w=this.n41*c+this.n42*b+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var c=a.x,b=a.y,d=a.z;a.x=c*this.n11+b*this.n12+d*this.n13;a.y=c*this.n21+b*this.n22+d*this.n23;a.z=c*this.n31+b*this.n32+d*this.n33;a.normalize();
return a},crossVector:function(a){var c=new THREE.Vector4;c.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;c.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;c.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;c.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return c},multiply:function(a,c){var b=a.n11,d=a.n12,e=a.n13,g=a.n14,h=a.n21,j=a.n22,k=a.n23,n=a.n24,t=a.n31,z=a.n32,v=a.n33,o=a.n34,w=a.n41,y=a.n42,B=a.n43,u=a.n44,E=c.n11,x=c.n12,M=c.n13,I=c.n14,W=c.n21,N=c.n22,
f=c.n23,V=c.n24,T=c.n31,da=c.n32,fa=c.n33,J=c.n34;this.n11=b*E+d*W+e*T;this.n12=b*x+d*N+e*da;this.n13=b*M+d*f+e*fa;this.n14=b*I+d*V+e*J+g;this.n21=h*E+j*W+k*T;this.n22=h*x+j*N+k*da;this.n23=h*M+j*f+k*fa;this.n24=h*I+j*V+k*J+n;this.n31=t*E+z*W+v*T;this.n32=t*x+z*N+v*da;this.n33=t*M+z*f+v*fa;this.n34=t*I+z*V+v*J+o;this.n41=w*E+y*W+B*T;this.n42=w*x+y*N+B*da;this.n43=w*M+y*f+B*fa;this.n44=w*I+y*V+B*J+u;return this},multiplyToArray:function(a,c,b){this.multiply(a,c);b[0]=this.n11;b[1]=this.n21;b[2]=this.n31;
b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=
this.n11,c=this.n12,b=this.n13,d=this.n14,e=this.n21,g=this.n22,h=this.n23,j=this.n24,k=this.n31,n=this.n32,t=this.n33,z=this.n34,v=this.n41,o=this.n42,w=this.n43,y=this.n44;return d*h*n*v-b*j*n*v-d*g*t*v+c*j*t*v+b*g*z*v-c*h*z*v-d*h*k*o+b*j*k*o+d*e*t*o-a*j*t*o-b*e*z*o+a*h*z*o+d*g*k*w-c*j*k*w-d*e*n*w+a*j*n*w+c*e*z*w-a*g*z*w-b*g*k*y+c*h*k*y+b*e*n*y-a*h*n*y-c*e*t*y+a*g*t*y},transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=
this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;
this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=
this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,c){a[c]=this.n11;a[c+1]=this.n21;a[c+2]=this.n31;a[c+3]=this.n41;a[c+4]=this.n12;a[c+5]=this.n22;a[c+6]=this.n32;a[c+7]=this.n42;a[c+8]=this.n13;a[c+9]=this.n23;a[c+10]=this.n33;a[c+11]=this.n43;a[c+12]=this.n14;a[c+13]=this.n24;a[c+14]=this.n34;a[c+15]=this.n44;return a},setTranslation:function(a,c,b){this.set(1,0,0,a,0,1,0,c,0,0,1,b,0,0,0,1);return this},setScale:function(a,
c,b){this.set(a,0,0,0,0,c,0,0,0,0,b,0,0,0,0,1);return this},setRotationX:function(a){var c=Math.cos(a);a=Math.sin(a);this.set(1,0,0,0,0,c,-a,0,0,a,c,0,0,0,0,1);return this},setRotationY:function(a){var c=Math.cos(a);a=Math.sin(a);this.set(c,0,a,0,0,1,0,0,-a,0,c,0,0,0,0,1);return this},setRotationZ:function(a){var c=Math.cos(a);a=Math.sin(a);this.set(c,-a,0,0,a,c,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,c){var b=Math.cos(c),d=Math.sin(c),e=1-b,g=a.x,h=a.y,j=a.z,k=e*g,n=e*h;this.set(k*
g+b,k*h-d*j,k*j+d*h,0,k*h+d*j,n*h+b,n*j-d*g,0,k*j-d*h,n*j+d*g,e*j*j+b,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},setRotationFromEuler:function(a){var c=a.x,b=a.y,d=a.z;a=Math.cos(c);c=Math.sin(c);var e=Math.cos(b);b=Math.sin(b);var g=Math.cos(d);d=Math.sin(d);var h=a*b,j=c*b;this.n11=e*g;this.n12=-e*d;this.n13=b;this.n21=j*g+a*d;this.n22=-j*d+a*g;this.n23=-c*e;this.n31=-h*g+c*d;this.n32=h*d+c*g;this.n33=a*e;return this},setRotationFromQuaternion:function(a){var c=
a.x,b=a.y,d=a.z,e=a.w,g=c+c,h=b+b,j=d+d;a=c*g;var k=c*h;c*=j;var n=b*h;b*=j;d*=j;g*=e;h*=e;e*=j;this.n11=1-(n+d);this.n12=k-e;this.n13=c+h;this.n21=k+e;this.n22=1-(a+d);this.n23=b-g;this.n31=c-h;this.n32=b+g;this.n33=1-(a+n);return this},scale:function(a){var c=a.x,b=a.y;a=a.z;this.n11*=c;this.n12*=b;this.n13*=a;this.n21*=c;this.n22*=b;this.n23*=a;this.n31*=c;this.n32*=b;this.n33*=a;this.n41*=c;this.n42*=b;this.n43*=a;return this},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=
a.n34},extractRotation:function(a,c){var b=1/c.x,d=1/c.y,e=1/c.z;this.n11=a.n11*b;this.n21=a.n21*b;this.n31=a.n31*b;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*e;this.n23=a.n23*e;this.n33=a.n33*e}};
THREE.Matrix4.makeInvert=function(a,c){var b=a.n11,d=a.n12,e=a.n13,g=a.n14,h=a.n21,j=a.n22,k=a.n23,n=a.n24,t=a.n31,z=a.n32,v=a.n33,o=a.n34,w=a.n41,y=a.n42,B=a.n43,u=a.n44;c===undefined&&(c=new THREE.Matrix4);c.n11=k*o*y-n*v*y+n*z*B-j*o*B-k*z*u+j*v*u;c.n12=g*v*y-e*o*y-g*z*B+d*o*B+e*z*u-d*v*u;c.n13=e*n*y-g*k*y+g*j*B-d*n*B-e*j*u+d*k*u;c.n14=g*k*z-e*n*z-g*j*v+d*n*v+e*j*o-d*k*o;c.n21=n*v*w-k*o*w-n*t*B+h*o*B+k*t*u-h*v*u;c.n22=e*o*w-g*v*w+g*t*B-b*o*B-e*t*u+b*v*u;c.n23=g*k*w-e*n*w-g*h*B+b*n*B+e*h*u-b*k*u;
c.n24=e*n*t-g*k*t+g*h*v-b*n*v-e*h*o+b*k*o;c.n31=j*o*w-n*z*w+n*t*y-h*o*y-j*t*u+h*z*u;c.n32=g*z*w-d*o*w-g*t*y+b*o*y+d*t*u-b*z*u;c.n33=e*n*w-g*j*w+g*h*y-b*n*y-d*h*u+b*j*u;c.n34=g*j*t-d*n*t-g*h*z+b*n*z+d*h*o-b*j*o;c.n41=k*z*w-j*v*w-k*t*y+h*v*y+j*t*B-h*z*B;c.n42=d*v*w-e*z*w+e*t*y-b*v*y-d*t*B+b*z*B;c.n43=e*j*w-d*k*w-e*h*y+b*k*y+d*h*B-b*j*B;c.n44=d*k*t-e*j*t+e*h*z-b*k*z-d*h*v+b*j*v;c.multiplyScalar(1/a.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(a){var c=a.m33,b=c.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,h=-a.n33*a.n12+a.n32*a.n13,j=a.n33*a.n11-a.n31*a.n13,k=-a.n32*a.n11+a.n31*a.n12,n=a.n23*a.n12-a.n22*a.n13,t=-a.n23*a.n11+a.n21*a.n13,z=a.n22*a.n11-a.n21*a.n12;a=a.n11*d+a.n21*h+a.n31*n;if(a==0)throw"matrix not invertible";a=1/a;b[0]=a*d;b[1]=a*e;b[2]=a*g;b[3]=a*h;b[4]=a*j;b[5]=a*k;b[6]=a*n;b[7]=a*t;b[8]=a*z;return c};
THREE.Matrix4.makeFrustum=function(a,c,b,d,e,g){var h;h=new THREE.Matrix4;h.n11=2*e/(c-a);h.n12=0;h.n13=(c+a)/(c-a);h.n14=0;h.n21=0;h.n22=2*e/(d-b);h.n23=(d+b)/(d-b);h.n24=0;h.n31=0;h.n32=0;h.n33=-(g+e)/(g-e);h.n34=-2*g*e/(g-e);h.n41=0;h.n42=0;h.n43=-1;h.n44=0;return h};THREE.Matrix4.makePerspective=function(a,c,b,d){var e;a=b*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*c,a*c,e,a,b,d)};
THREE.Matrix4.makeOrtho=function(a,c,b,d,e,g){var h,j,k,n;h=new THREE.Matrix4;j=c-a;k=b-d;n=g-e;h.n11=2/j;h.n12=0;h.n13=0;h.n14=-((c+a)/j);h.n21=0;h.n22=2/k;h.n23=0;h.n24=-((b+d)/k);h.n31=0;h.n32=0;h.n33=-2/n;h.n34=-((g+e)/n);h.n41=0;h.n42=0;h.n43=0;h.n44=1;return h};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=undefined;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.scale=new THREE.Vector3(1,1,1);this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixAutoUpdate=!0;this.matrixWorldNeedsUpdate=!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=
!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={translate:function(a,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===-1){a.parent!==
undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var c=this;c instanceof THREE.Scene===!1&&c!==undefined;)c=c.parent;c!==undefined&&c.addChildRecurse(a)}},removeChild:function(a){var c=this.children.indexOf(a);if(c!==-1){a.parent=undefined;this.children.splice(c,1)}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation);if(this.scale.x!==1||this.scale.y!==
1||this.scale.z!==1){this.matrix.scale(this.scale);this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z))}this.matrixWorldNeedsUpdate=!0},update:function(a,c,b){if(this.visible){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||c){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale);this.matrixWorldNeedsUpdate=!1;c=!0}a=0;for(var d=this.children.length;a<
d;a++)this.children[a].update(this.matrixWorld,c,b)}}};THREE.Quaternion=function(a,c,b,d){this.set(a||0,c||0,b||0,d!==undefined?d:1)};
THREE.Quaternion.prototype={set:function(a,c,b,d){this.x=a;this.y=c;this.z=b;this.w=d;return this},setFromEuler:function(a){var c=0.5*Math.PI/360,b=a.x*c,d=a.y*c,e=a.z*c;a=Math.cos(d);d=Math.sin(d);c=Math.cos(-e);e=Math.sin(-e);var g=Math.cos(b);b=Math.sin(b);var h=a*c,j=d*e;this.w=h*g-j*b;this.x=h*b+j*g;this.y=d*c*g+a*e*b;this.z=a*e*g-d*c*b;return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=
-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);if(a==0)this.w=this.z=this.y=this.x=0;else{a=1/a;this.x*=a;this.y*=a;this.z*=a;this.w*=a}return this},multiplySelf:function(a){var c=this.x,b=this.y,d=this.z,e=this.w,g=a.x,h=a.y,j=a.z;a=a.w;this.x=c*a+e*g+b*j-d*h;this.y=b*a+e*h+d*g-c*j;this.z=d*a+e*j+c*h-b*g;this.w=e*a-c*g-b*h-d*j;return this},
multiplyVector3:function(a,c){c||(c=a);var b=a.x,d=a.y,e=a.z,g=this.x,h=this.y,j=this.z,k=this.w,n=k*b+h*e-j*d,t=k*d+j*b-g*e,z=k*e+g*d-h*b;b=-g*b-h*d-j*e;c.x=n*k+b*-g+t*-j-z*-h;c.y=t*k+b*-h+z*-g-n*-j;c.z=z*k+b*-j+n*-h-t*-g;return c}};
THREE.Quaternion.slerp=function(a,c,b,d){var e=a.w*c.w+a.x*c.x+a.y*c.y+a.z*c.z;if(Math.abs(e)>=1){b.w=a.w;b.x=a.x;b.y=a.y;b.z=a.z;return b}var g=Math.acos(e),h=Math.sqrt(1-e*e);if(Math.abs(h)<0.0010){b.w=0.5*(a.w+c.w);b.x=0.5*(a.x+c.x);b.y=0.5*(a.y+c.y);b.z=0.5*(a.z+c.z);return b}e=Math.sin((1-d)*g)/h;d=Math.sin(d*g)/h;b.w=a.w*e+c.w*d;b.x=a.x*e+c.x*d;b.y=a.y*e+c.y*d;b.z=a.z*e+c.z*d;return b};
THREE.Vertex=function(a,c){this.position=a||new THREE.Vector3;this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.normal=c||new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.normalScreen=new THREE.Vector3;this.tangent=new THREE.Vector4;this.__visible=!0};
THREE.Face3=function(a,c,b,d,e){this.a=a;this.b=c;this.c=b;this.centroid=new THREE.Vector3;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.materials=e instanceof Array?e:[e]};THREE.Face4=function(a,c,b,d,e,g){this.a=a;this.b=c;this.c=b;this.d=d;this.centroid=new THREE.Vector3;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.materials=g instanceof Array?g:[g]};
THREE.UV=function(a,c){this.set(a||0,c||0)};THREE.UV.prototype={set:function(a,c){this.u=a;this.v=c;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.faces=[];this.uvs=[];this.uvs2=[];this.colors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.hasTangents=!1};
THREE.Geometry.prototype={computeCentroids:function(){var a,c,b;a=0;for(c=this.faces.length;a<c;a++){b=this.faces[a];b.centroid.set(0,0,0);if(b instanceof THREE.Face3){b.centroid.addSelf(this.vertices[b.a].position);b.centroid.addSelf(this.vertices[b.b].position);b.centroid.addSelf(this.vertices[b.c].position);b.centroid.divideScalar(3)}else if(b instanceof THREE.Face4){b.centroid.addSelf(this.vertices[b.a].position);b.centroid.addSelf(this.vertices[b.b].position);b.centroid.addSelf(this.vertices[b.c].position);
b.centroid.addSelf(this.vertices[b.d].position);b.centroid.divideScalar(4)}}},computeFaceNormals:function(a){var c,b,d,e,g,h,j=new THREE.Vector3,k=new THREE.Vector3;d=0;for(e=this.vertices.length;d<e;d++){g=this.vertices[d];g.normal.set(0,0,0)}d=0;for(e=this.faces.length;d<e;d++){g=this.faces[d];if(a&&g.vertexNormals.length){j.set(0,0,0);c=0;for(b=g.vertexNormals.length;c<b;c++)j.addSelf(g.vertexNormals[c]);j.divideScalar(3)}else{c=this.vertices[g.a];b=this.vertices[g.b];h=this.vertices[g.c];j.sub(h.position,
b.position);k.sub(c.position,b.position);j.crossSelf(k)}j.isZero()||j.normalize();g.normal.copy(j)}},computeVertexNormals:function(){var a,c,b,d;if(this.__tmpVertices==undefined){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(c=this.vertices.length;a<c;a++)d[a]=new THREE.Vector3;a=0;for(c=this.faces.length;a<c;a++){b=this.faces[a];if(b instanceof THREE.Face3)b.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(b instanceof THREE.Face4)b.vertexNormals=[new THREE.Vector3,
new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}}else{d=this.__tmpVertices;a=0;for(c=this.vertices.length;a<c;a++)d[a].set(0,0,0)}a=0;for(c=this.faces.length;a<c;a++){b=this.faces[a];if(b instanceof THREE.Face3){d[b.a].addSelf(b.normal);d[b.b].addSelf(b.normal);d[b.c].addSelf(b.normal)}else if(b instanceof THREE.Face4){d[b.a].addSelf(b.normal);d[b.b].addSelf(b.normal);d[b.c].addSelf(b.normal);d[b.d].addSelf(b.normal)}}a=0;for(c=this.vertices.length;a<c;a++)d[a].normalize();a=0;for(c=this.faces.length;a<
c;a++){b=this.faces[a];if(b instanceof THREE.Face3){b.vertexNormals[0].copy(d[b.a]);b.vertexNormals[1].copy(d[b.b]);b.vertexNormals[2].copy(d[b.c])}else if(b instanceof THREE.Face4){b.vertexNormals[0].copy(d[b.a]);b.vertexNormals[1].copy(d[b.b]);b.vertexNormals[2].copy(d[b.c]);b.vertexNormals[3].copy(d[b.d])}}},computeTangents:function(){function a(J,ca,xa,ea,va,ia,ga){g=J.vertices[ca].position;h=J.vertices[xa].position;j=J.vertices[ea].position;k=e[va];n=e[ia];t=e[ga];z=h.x-g.x;v=j.x-g.x;o=h.y-g.y;
w=j.y-g.y;y=h.z-g.z;B=j.z-g.z;u=n.u-k.u;E=t.u-k.u;x=n.v-k.v;M=t.v-k.v;I=1/(u*M-E*x);f.set((M*z-x*v)*I,(M*o-x*w)*I,(M*y-x*B)*I);V.set((u*v-E*z)*I,(u*w-E*o)*I,(u*B-E*y)*I);W[ca].addSelf(f);W[xa].addSelf(f);W[ea].addSelf(f);N[ca].addSelf(V);N[xa].addSelf(V);N[ea].addSelf(V)}var c,b,d,e,g,h,j,k,n,t,z,v,o,w,y,B,u,E,x,M,I,W=[],N=[],f=new THREE.Vector3,V=new THREE.Vector3,T=new THREE.Vector3,da=new THREE.Vector3,fa=new THREE.Vector3;c=0;for(b=this.vertices.length;c<b;c++){W[c]=new THREE.Vector3;N[c]=new THREE.Vector3}c=
0;for(b=this.faces.length;c<b;c++){d=this.faces[c];e=this.uvs[c];if(d instanceof THREE.Face3){a(this,d.a,d.b,d.c,0,1,2);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2])}else if(d instanceof THREE.Face4){a(this,d.a,d.b,d.c,0,1,2);a(this,d.a,d.b,d.d,0,1,3);this.vertices[d.a].normal.copy(d.vertexNormals[0]);this.vertices[d.b].normal.copy(d.vertexNormals[1]);this.vertices[d.c].normal.copy(d.vertexNormals[2]);
this.vertices[d.d].normal.copy(d.vertexNormals[3])}}c=0;for(b=this.vertices.length;c<b;c++){fa.copy(this.vertices[c].normal);d=W[c];T.copy(d);T.subSelf(fa.multiplyScalar(fa.dot(d))).normalize();da.cross(this.vertices[c].normal,d);d=da.dot(N[c]);d=d<0?-1:1;this.vertices[c].tangent.set(T.x,T.y,T.z,d)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],
z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,b=this.vertices.length;c<b;c++){a=this.vertices[c];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>
this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=this.boundingSphere===null?0:this.boundingSphere.radius,c=0,b=this.vertices.length;c<b;c++)a=Math.max(a,this.vertices[c].position.length());this.boundingSphere={radius:a}}};THREE.GeometryIdCounter=0;
THREE.Spline=function(){function a(v,o,w,y,B,u,E){v=(w-v)*0.5;y=(y-o)*0.5;return(2*(o-w)+v+y)*E+(-3*(o-w)-2*v-y)*u+v*B+o}var c=[],b={x:0,y:0,z:0},d,e,g,h,j,k,n,t,z;this.getPoint=function(v,o){d=(v.length-1)*o;e=Math.floor(d);g=d-e;c[0]=e==0?e:e-1;c[1]=e;c[2]=e>v.length-2?e:e+1;c[3]=e>v.length-3?e:e+2;k=v[c[0]];n=v[c[1]];t=v[c[2]];z=v[c[3]];h=g*g;j=g*h;b.x=a(k.x,n.x,t.x,z.x,g,h,j);b.y=a(k.y,n.y,t.y,z.y,g,h,j);b.z=a(k.z,n.z,t.z,z.z,g,h,j);return b}};
THREE.AnimationHandler=function(){var a=[],c={},b={};b.update=function(e){for(var g=0;g<a.length;g++)a[g].update(e)};b.addToUpdate=function(e){a.indexOf(e)===-1&&a.push(e)};b.removeFromUpdate=function(e){e=a.indexOf(e);e!==-1&&a.splice(e,1)};b.add=function(e){c[e.name]!==undefined&&console.log("THREE.AnimationHandler.add: Warning! "+e.name+" already exists in library. Overwriting.");c[e.name]=e;if(e.initialized!==!0){for(var g=0;g<e.hierarchy.length;g++){for(var h=0;h<e.hierarchy[g].keys.length;h++){if(e.hierarchy[g].keys[h].time<
0)e.hierarchy[g].keys[h].time=0;if(e.hierarchy[g].keys[h].rot!==undefined&&!(e.hierarchy[g].keys[h].rot instanceof THREE.Quaternion)){var j=e.hierarchy[g].keys[h].rot;e.hierarchy[g].keys[h].rot=new THREE.Quaternion(j[0],j[1],j[2],j[3])}}for(h=1;h<e.hierarchy[g].keys.length;h++)if(e.hierarchy[g].keys[h].time===e.hierarchy[g].keys[h-1].time){e.hierarchy[g].keys.splice(h,1);h--}for(h=1;h<e.hierarchy[g].keys.length;h++)e.hierarchy[g].keys[h].index=h}h=parseInt(e.length*e.fps,10);e.JIT={};e.JIT.hierarchy=
[];for(g=0;g<e.hierarchy.length;g++)e.JIT.hierarchy.push(Array(h));e.initialized=!0}};b.get=function(e){if(typeof e==="string")if(c[e])return c[e];else{console.log("THREE.AnimationHandler.get: Couldn't find animation "+e);return null}};b.parse=function(e){var g=[];if(e instanceof THREE.SkinnedMesh)for(var h=0;h<e.bones.length;h++)g.push(e.bones[h]);else d(e,g);return g};var d=function(e,g){g.push(e);for(var h=0;h<e.children.length;h++)d(e.children[h],g)};b.LINEAR=0;b.CATMULLROM=1;b.CATMULLROM_FORWARD=
2;return b}();THREE.Animation=function(a,c,b,d){this.root=a;this.data=THREE.AnimationHandler.get(c);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.isPlaying=!1;this.isPaused=!0;this.loop=!0;this.interpolationType=b!==undefined?b:THREE.AnimationHandler.LINEAR;this.JITCompile=d!==undefined?d:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,c){if(!this.isPlaying){this.isPlaying=!0;this.loop=a!==undefined?a:!0;this.currentTime=c!==undefined?c:0;var b,d=this.hierarchy.length,e;for(b=0;b<d;b++){e=this.hierarchy[b];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)e.useQuaternion=!0;e.matrixAutoUpdate=!0;if(e.animationCache===undefined){e.animationCache={};e.animationCache.prevKey={pos:0,rot:0,scl:0};e.animationCache.nextKey={pos:0,rot:0,scl:0};e.animationCache.originalMatrix=
e instanceof THREE.Bone?e.skinMatrix:e.matrix}var g=e.animationCache.prevKey;e=e.animationCache.nextKey;g.pos=this.data.hierarchy[b].keys[0];g.rot=this.data.hierarchy[b].keys[0];g.scl=this.data.hierarchy[b].keys[0];e.pos=this.getNextKeyWith("pos",b,1);e.rot=this.getNextKeyWith("rot",b,1);e.scl=this.getNextKeyWith("scl",b,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(this.hierarchy[a].animationCache!==undefined){if(this.hierarchy[a]instanceof THREE.Bone)this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix;else this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix;delete this.hierarchy[a].animationCache}};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var c=["pos","rot","scl"],b,d,e,g,h,j,k,n,t=this.data.JIT.hierarchy,z,v;this.currentTime+=a;v=this.currentTime;z=this.currentTime%=this.data.length;n=parseInt(Math.min(z*this.data.fps,this.data.length*this.data.fps),10);for(var o=0,w=this.hierarchy.length;o<w;o++){a=this.hierarchy[o];k=a.animationCache;if(this.JITCompile&&t[o][n]!==undefined)if(a instanceof THREE.Bone){a.skinMatrix=t[o][n];a.matrixAutoUpdate=!1;a.matrixWorldNeedsUpdate=
!1}else{a.matrix=t[o][n];a.matrixAutoUpdate=!1;a.matrixWorldNeedsUpdate=!0}else{if(this.JITCompile)if(a instanceof THREE.Bone)a.skinMatrix=a.animationCache.originalMatrix;else a.matrix=a.animationCache.originalMatrix;for(var y=0;y<3;y++){b=c[y];h=k.prevKey[b];j=k.nextKey[b];if(j.time<=v){if(z<v)if(this.loop){h=this.data.hierarchy[o].keys[0];for(j=this.getNextKeyWith(b,o,1);j.time<z;){h=j;j=this.getNextKeyWith(b,o,j.index+1)}}else{this.stop();return}else{do{h=j;j=this.getNextKeyWith(b,o,j.index+1)}while(j.time<
z)}k.prevKey[b]=h;k.nextKey[b]=j}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;d=(z-h.time)/(j.time-h.time);e=h[b];g=j[b];if(d<0||d>1){console.log("THREE.Animation.update: Warning! Scale out of bounds:"+d+" on bone "+o);d=d<0?0:1}if(b==="pos"){b=a.position;if(this.interpolationType===THREE.AnimationHandler.LINEAR){b.x=e[0]+(g[0]-e[0])*d;b.y=e[1]+(g[1]-e[1])*d;b.z=e[2]+(g[2]-e[2])*d}else if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){this.points[0]=
this.getPrevKeyWith("pos",o,h.index-1).pos;this.points[1]=e;this.points[2]=g;this.points[3]=this.getNextKeyWith("pos",o,j.index+1).pos;d=d*0.33+0.33;e=this.interpolateCatmullRom(this.points,d);b.x=e[0];b.y=e[1];b.z=e[2];if(this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){d=this.interpolateCatmullRom(this.points,d*1.01);this.target.set(d[0],d[1],d[2]);this.target.subSelf(b);this.target.y=0;this.target.normalize();d=Math.atan2(this.target.x,this.target.z);a.rotation.set(0,d,0)}}}else if(b===
"rot")THREE.Quaternion.slerp(e,g,a.quaternion,d);else if(b==="scl"){b=a.scale;b.x=e[0]+(g[0]-e[0])*d;b.y=e[1]+(g[1]-e[1])*d;b.z=e[2]+(g[2]-e[2])*d}}}}if(this.JITCompile&&t[0][n]===undefined){this.hierarchy[0].update(undefined,!0);for(o=0;o<this.hierarchy.length;o++)t[o][n]=this.hierarchy[o]instanceof THREE.Bone?this.hierarchy[o].skinMatrix.clone():this.hierarchy[o].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,c){var b=[],d=[],e,g,h,j,k,n;e=(a.length-1)*c;g=Math.floor(e);e-=g;b[0]=g==0?g:g-1;b[1]=g;b[2]=g>a.length-2?g:g+1;b[3]=g>a.length-3?g:g+2;g=a[b[0]];j=a[b[1]];k=a[b[2]];n=a[b[3]];b=e*e;h=e*b;d[0]=this.interpolate(g[0],j[0],k[0],n[0],e,b,h);d[1]=this.interpolate(g[1],j[1],k[1],n[1],e,b,h);d[2]=this.interpolate(g[2],j[2],k[2],n[2],e,b,h);return d};
THREE.Animation.prototype.interpolate=function(a,c,b,d,e,g,h){a=(b-a)*0.5;d=(d-c)*0.5;return(2*(c-b)+a+d)*h+(-3*(c-b)-2*a-d)*g+a*e+c};THREE.Animation.prototype.getNextKeyWith=function(a,c,b){var d=this.data.hierarchy[c].keys;if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)b=b<d.length-1?b:d.length-1;else b%=d.length;for(;b<d.length;b++)if(d[b][a]!==undefined)return d[b];return this.data.hierarchy[c].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,c,b){var d=this.data.hierarchy[c].keys;for(b=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?b>0?b:0:b>=0?b:b+d.length;b>=0;b--)if(d[b][a]!==undefined)return d[b];return this.data.hierarchy[c].keys[d.length-1]};
THREE.Camera=function(a,c,b,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=c||1;this.near=b||0.1;this.far=d||2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.translate=function(a,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(a));this.target.position.addSelf(c.multiplyScalar(a))};THREE.Camera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};THREE.Camera.prototype.updateMatrix=function(){this.update(undefined,!0)};
THREE.Camera.prototype.update=function(a,c,b){if(this.useTarget){this.matrix.lookAt(this.position,this.target.position,this.up);this.matrix.setPosition(this.position);a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);c=!0}else{this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=
!1;c=!0;THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse)}}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,c,b)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=c||1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=c||1};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.FlatShading=0;THREE.SmoothShading=1;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.BillboardBlending=3;THREE.ReverseSubtractiveBlending=4;THREE.MaterialCounter={value:0};THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};
THREE.LineBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;this.depthTest=!0;this.linewidth=1;this.linejoin=this.linecap="round";this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.linewidth!==undefined)this.linewidth=
a.linewidth;if(a.linecap!==undefined)this.linecap=a.linecap;if(a.linejoin!==undefined)this.linejoin=a.linejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};
THREE.MeshBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshLambertMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){a.color!==undefined&&
this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=
a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshPhongMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.ambient=new THREE.Color(328965);this.specular=new THREE.Color(1118481);this.shininess=30;this.opacity=1;this.envMap=this.lightMap=this.map=null;this.combine=THREE.MultiplyOperation;this.reflectivity=1;this.refractionRatio=0.98;this.fog=!0;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=
this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.color!==undefined)this.color=new THREE.Color(a.color);if(a.ambient!==undefined)this.ambient=new THREE.Color(a.ambient);if(a.specular!==undefined)this.specular=new THREE.Color(a.specular);if(a.shininess!==undefined)this.shininess=a.shininess;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.lightMap!==undefined)this.lightMap=a.lightMap;if(a.map!==undefined)this.map=a.map;if(a.envMap!==undefined)this.envMap=a.envMap;if(a.combine!==
undefined)this.combine=a.combine;if(a.reflectivity!==undefined)this.reflectivity=a.reflectivity;if(a.refractionRatio!==undefined)this.refractionRatio=a.refractionRatio;if(a.fog!==undefined)this.fog=a.fog;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==
undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.MeshDepthMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};
THREE.MeshNormalMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.opacity=1;this.shading=THREE.FlatShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;if(a){if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==
undefined)this.wireframeLinewidth=a.wireframeLinewidth}};THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.vertexShader=this.fragmentShader="void main() {}";this.uniforms={};this.opacity=1;this.shading=THREE.SmoothShading;this.blending=THREE.NormalBlending;this.depthTest=!0;this.wireframe=!1;this.wireframeLinewidth=1;this.wireframeLinejoin=this.wireframeLinecap="round";this.vertexColors=!1;this.skinning=!1;if(a){if(a.fragmentShader!==undefined)this.fragmentShader=a.fragmentShader;if(a.vertexShader!==undefined)this.vertexShader=
a.vertexShader;if(a.uniforms!==undefined)this.uniforms=a.uniforms;if(a.opacity!==undefined)this.opacity=a.opacity;if(a.shading!==undefined)this.shading=a.shading;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.wireframe!==undefined)this.wireframe=a.wireframe;if(a.wireframeLinewidth!==undefined)this.wireframeLinewidth=a.wireframeLinewidth;if(a.wireframeLinecap!==undefined)this.wireframeLinecap=a.wireframeLinecap;if(a.wireframeLinejoin!==
undefined)this.wireframeLinejoin=a.wireframeLinejoin;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors;if(a.skinning!==undefined)this.skinning=a.skinning}};
THREE.ParticleBasicMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.map=null;this.size=1;this.sizeAttenuation=!0;this.blending=THREE.NormalBlending;this.depthTest=!0;this.offset=new THREE.Vector2;this.vertexColors=!1;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.map!==undefined)this.map=a.map;if(a.size!==undefined)this.size=a.size;if(a.sizeAttenuation!==undefined)this.sizeAttenuation=
a.sizeAttenuation;if(a.blending!==undefined)this.blending=a.blending;if(a.depthTest!==undefined)this.depthTest=a.depthTest;if(a.vertexColors!==undefined)this.vertexColors=a.vertexColors}};THREE.ParticleCircleMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.color=new THREE.Color(16777215);this.opacity=1;this.blending=THREE.NormalBlending;if(a){a.color!==undefined&&this.color.setHex(a.color);if(a.opacity!==undefined)this.opacity=a.opacity;if(a.blending!==undefined)this.blending=a.blending}};
THREE.ParticleDOMMaterial=function(a){this.id=THREE.MaterialCounter.value++;this.domElement=a};THREE.Texture=function(a,c,b,d,e,g){this.image=a;this.mapping=c!==undefined?c:new THREE.UVMapping;this.wrapS=b!==undefined?b:THREE.ClampToEdgeWrapping;this.wrapT=d!==undefined?d:THREE.ClampToEdgeWrapping;this.magFilter=e!==undefined?e:THREE.LinearFilter;this.minFilter=g!==undefined?g:THREE.LinearMipMapLinearFilter;this.needsUpdate=!1};
THREE.Texture.prototype={clone:function(){return new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter)}};THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;
THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;
THREE.RenderTarget=function(a,c,b){this.width=a;this.height=c;b=b||{};this.wrapS=b.wrapS!==undefined?b.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=b.wrapT!==undefined?b.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=b.magFilter!==undefined?b.magFilter:THREE.LinearFilter;this.minFilter=b.minFilter!==undefined?b.minFilter:THREE.LinearMipMapLinearFilter;this.format=b.format!==undefined?b.format:THREE.RGBFormat;this.type=b.type!==undefined?b.type:THREE.UnsignedByteType};
var Uniforms={clone:function(a){var c,b,d,e={};for(c in a){e[c]={};for(b in a[c]){d=a[c][b];e[c][b]=d instanceof THREE.Color||d instanceof THREE.Vector3||d instanceof THREE.Texture?d.clone():d}}return e},merge:function(a){var c,b,d,e={};for(c=0;c<a.length;c++){d=this.clone(a[c]);for(b in d)e[b]=d[b]}return e}};THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a];this.matrixAutoUpdate=!1};THREE.Particle.prototype=new THREE.Object3D;
THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(a,c,b){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.type=b!=undefined?b:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;
THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;THREE.Mesh=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c&&c.length?c:[c];this.flipSided=!1;this.doubleSided=!1;this.overdraw=!1;if(this.geometry){this.geometry.boundingSphere||this.geometry.computeBoundingSphere();this.boundRadius=a.boundingSphere.radius}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,c,b){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.skinMatrix,c,b):a.update(this.matrixWorld,!0,b)}}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
c,b)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1){a.parent!==undefined&&a.parent.removeChild(a);a.parent=this;this.children.push(a);if(!(a instanceof THREE.Bone))this.hasNoneBoneChildren=!0}};if(!window.Float32Array)window.Float32Array=Array;
THREE.SkinnedMesh=function(a,c){THREE.Mesh.call(this,a,c);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var b,d,e,g,h,j;if(this.geometry.bones!==undefined){for(b=0;b<this.geometry.bones.length;b++){e=this.geometry.bones[b];g=e.pos;h=e.rotq;j=e.scl;d=this.addBone();d.name=e.name;d.position.set(g[0],g[1],g[2]);d.quaternion.set(h[0],h[1],h[2],h[3]);d.useQuaternion=!0;j!==undefined?d.scale.set(j[0],j[1],j[2]):d.scale.set(1,1,1)}for(b=0;b<this.bones.length;b++){e=this.geometry.bones[b];
d=this.bones[b];e.parent===-1?this.addChild(d):this.bones[e.parent].addChild(d)}this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(a,c,b){if(this.visible){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}var d,e=this.children.length;for(d=0;d<e;d++){a=this.children[d];a instanceof THREE.Bone?a.update(this.identityMatrix,!1,b):a.update(this.matrixWorld,c,b)}b=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(c=0;c<b;c++)ba[c].skinMatrix.flattenToArrayOffset(bm,
c*16)}};THREE.SkinnedMesh.prototype.addBone=function(a){a===undefined&&(a=new THREE.Bone(this));this.bones.push(a);return a};
THREE.SkinnedMesh.prototype.pose=function(){this.update(undefined,!0);for(var a,c=[],b=0;b<this.bones.length;b++){a=this.bones[b];c.push(THREE.Matrix4.makeInvert(a.skinMatrix));a.skinMatrix.flattenToArrayOffset(this.boneMatrices,b*16)}if(this.geometry.skinVerticesA===undefined){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var d;for(a=0;a<this.geometry.skinIndices.length;a++){b=this.geometry.vertices[a].position;var e=this.geometry.skinIndices[a].x,g=this.geometry.skinIndices[a].y;
d=new THREE.Vector3(b.x,b.y,b.z);this.geometry.skinVerticesA.push(c[e].multiplyVector3(d));d=new THREE.Vector3(b.x,b.y,b.z);this.geometry.skinVerticesB.push(c[g].multiplyVector3(d));if(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y!==1){b=(1-(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y))*0.5;this.geometry.skinWeights[a].x+=b;this.geometry.skinWeights[a].y+=b}}}};
THREE.Ribbon=function(a,c){THREE.Object3D.call(this);this.geometry=a;this.materials=c instanceof Array?c:[c];this.flipSided=!1;this.doubleSided=!1};THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;
THREE.Sound=function(a,c,b,d){THREE.Object3D.call(this);this.isLoaded=!1;this.isAddedToDOM=!1;this.isPlaying=!1;this.duration=-1;this.radius=c!==undefined?Math.abs(c):100;this.volume=Math.min(1,Math.max(0,b!==undefined?b:1));this.domElement=document.createElement("audio");this.domElement.volume=0;this.domElement.pan=0;this.domElement.loop=d!==undefined?d:!0;this.sources=a instanceof Array?a:[a];var e;b=this.sources.length;for(a=0;a<b;a++){c=this.sources[a];c.toLowerCase();if(c.indexOf(".mp3")!==-1)e=
"audio/mpeg";else if(c.indexOf(".ogg")!==-1)e="audio/ogg";else c.indexOf(".wav")!==-1&&(e="audio/wav");if(this.domElement.canPlayType(e)){e=document.createElement("source");e.src=this.sources[a];this.domElement.THREESound=this;this.domElement.appendChild(e);this.domElement.addEventListener("canplay",this.onLoad,!0);this.domElement.load();break}}};THREE.Sound.prototype=new THREE.Object3D;THREE.Sound.prototype.constructor=THREE.Sound;THREE.Sound.prototype.supr=THREE.Object3D.prototype;
THREE.Sound.prototype.onLoad=function(){var a=this.THREESound;if(!a.isLoaded){this.removeEventListener("canplay",this.onLoad,!0);a.isLoaded=!0;a.duration=this.duration;a.isPlaying&&a.play()}};THREE.Sound.prototype.addToDOM=function(a){this.isAddedToDOM=!0;a.appendChild(this.domElement)};THREE.Sound.prototype.play=function(a){this.isPlaying=!0;if(this.isLoaded){this.domElement.play();if(a)this.domElement.currentTime=a%this.duration}};THREE.Sound.prototype.pause=function(){this.isPlaying=!1;this.domElement.pause()};
THREE.Sound.prototype.stop=function(){this.isPlaying=!1;this.domElement.pause();this.domElement.currentTime=0};THREE.Sound.prototype.calculateVolumeAndPan=function(a){a=a.length();this.domElement.volume=a<=this.radius?this.volume*(1-a/this.radius):0};
THREE.Sound.prototype.update=function(a,c,b){if(this.matrixAutoUpdate){this.matrix.setPosition(this.position);c=!0}if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}var d=this.children.length;for(a=0;a<d;a++)this.children[a].update(this.matrixWorld,c,b)};THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;
THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.add=function(a,c){c===undefined&&(c=0);c=Math.abs(c);for(var b=0;b<this.LODs.length;b++)if(c<this.LODs[b].visibleAtDistance)break;this.LODs.splice(b,0,{visibleAtDistance:c,object3D:a});this.addChild(a)};
THREE.LOD.prototype.update=function(a,c,b){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate){a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix);this.matrixWorldNeedsUpdate=!1;c=!0}if(this.LODs.length>1){a=b.matrixWorldInverse;a=-(a.n31*this.position.x+a.n32*this.position.y+a.n33*this.position.z+a.n34);this.LODs[0].object3D.visible=!0;for(var d=1;d<this.LODs.length;d++)if(a>=this.LODs[d].visibleAtDistance){this.LODs[d-1].object3D.visible=
!1;this.LODs[d].object3D.visible=!0}else break;for(;d<this.LODs.length;d++)this.LODs[d].object3D.visible=!1}for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,c,b)};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.fog=null;this.objects=[];this.lights=[];this.sounds=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;
THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(a instanceof THREE.Sound)this.sounds.indexOf(a)===-1&&this.sounds.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1){this.objects.push(a);this.__objectsAdded.push(a)}for(var c=0;c<a.children.length;c++)this.addChildRecurse(a.children[c])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var c=this.lights.indexOf(a);c!==-1&&this.lights.splice(c,1)}else if(a instanceof THREE.Sound){c=this.sounds.indexOf(a);c!==-1&&this.sounds.splice(c,1)}else if(!(a instanceof THREE.Camera)){c=this.objects.indexOf(a);if(c!==-1){this.objects.splice(c,1);this.__objectsRemoved.push(a)}}for(c=0;c<a.children.length;c++)this.removeChildRecurse(a.children[c])};
THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(a,c,b){this.color=new THREE.Color(a);this.near=c||1;this.far=b||1E3};THREE.FogExp2=function(a,c){this.color=new THREE.Color(a);this.density=c!==undefined?c:2.5E-4};
THREE.Projector=function(){function a(N,f){return f.z-N.z}function c(N,f){var V=0,T=1,da=N.z+N.w,fa=f.z+f.w,J=-N.z+N.w,ca=-f.z+f.w;if(da>=0&&fa>=0&&J>=0&&ca>=0)return!0;else if(da<0&&fa<0||J<0&&ca<0)return!1;else{if(da<0)V=Math.max(V,da/(da-fa));else fa<0&&(T=Math.min(T,da/(da-fa)));if(J<0)V=Math.max(V,J/(J-ca));else ca<0&&(T=Math.min(T,J/(J-ca)));if(T<V)return!1;else{N.lerpSelf(f,V);f.lerpSelf(N,1-T);return!0}}}var b,d,e=[],g,h,j,k=[],n,t,z=[],v,o,w=[],y=new THREE.Vector4,B=new THREE.Vector4,u=new THREE.Matrix4,
E=new THREE.Matrix4,x=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],M=new THREE.Vector4,I=new THREE.Vector4,W;this.projectObjects=function(N,f,V){f=[];var T,da,fa;d=0;da=N.objects;N=0;for(T=da.length;N<T;N++){fa=da[N];var J;if(!(J=!fa.visible))if(J=fa instanceof THREE.Mesh){a:{J=void 0;for(var ca=fa.matrixWorld,xa=-fa.geometry.boundingSphere.radius*Math.max(fa.scale.x,Math.max(fa.scale.y,fa.scale.z)),ea=0;ea<6;ea++){J=x[ea].x*ca.n14+
x[ea].y*ca.n24+x[ea].z*ca.n34+x[ea].w;if(J<=xa){J=!1;break a}}J=!0}J=!J}if(!J){b=e[d]=e[d]||new THREE.RenderableObject;y.copy(fa.position);u.multiplyVector3(y);b.object=fa;b.z=y.z;f.push(b);d++}}V&&f.sort(a);return f};this.projectScene=function(N,f,V){var T=[],da=f.near,fa=f.far,J,ca,xa,ea,va,ia,ga,ta,ya,ha,aa,ma,na,R,ja,qa;j=t=o=0;f.matrixAutoUpdate&&f.updateMatrix();N.update(undefined,!1,f);u.multiply(f.projectionMatrix,f.matrixWorldInverse);x[0].set(u.n41-u.n11,u.n42-u.n12,u.n43-u.n13,u.n44-u.n14);
x[1].set(u.n41+u.n11,u.n42+u.n12,u.n43+u.n13,u.n44+u.n14);x[2].set(u.n41+u.n21,u.n42+u.n22,u.n43+u.n23,u.n44+u.n24);x[3].set(u.n41-u.n21,u.n42-u.n22,u.n43-u.n23,u.n44-u.n24);x[4].set(u.n41-u.n31,u.n42-u.n32,u.n43-u.n33,u.n44-u.n34);x[5].set(u.n41+u.n31,u.n42+u.n32,u.n43+u.n33,u.n44+u.n34);for(J=0;J<6;J++){ia=x[J];ia.divideScalar(Math.sqrt(ia.x*ia.x+ia.y*ia.y+ia.z*ia.z))}ia=this.projectObjects(N,f,!0);N=0;for(J=ia.length;N<J;N++){ga=ia[N].object;if(ga.visible){ta=ga.matrixWorld;aa=ga.matrixRotationWorld;
ya=ga.materials;ha=ga.overdraw;if(ga instanceof THREE.Mesh){ma=ga.geometry;na=ma.vertices;ca=0;for(xa=na.length;ca<xa;ca++){R=na[ca];R.positionWorld.copy(R.position);ta.multiplyVector3(R.positionWorld);ea=R.positionScreen;ea.copy(R.positionWorld);u.multiplyVector4(ea);ea.x/=ea.w;ea.y/=ea.w;R.__visible=ea.z>da&&ea.z<fa}ma=ma.faces;ca=0;for(xa=ma.length;ca<xa;ca++){R=ma[ca];if(R instanceof THREE.Face3){ea=na[R.a];va=na[R.b];ja=na[R.c];if(ea.__visible&&va.__visible&&ja.__visible&&(ga.doubleSided||ga.flipSided!=
(ja.positionScreen.x-ea.positionScreen.x)*(va.positionScreen.y-ea.positionScreen.y)-(ja.positionScreen.y-ea.positionScreen.y)*(va.positionScreen.x-ea.positionScreen.x)<0)){g=k[j]=k[j]||new THREE.RenderableFace3;g.v1.positionWorld.copy(ea.positionWorld);g.v2.positionWorld.copy(va.positionWorld);g.v3.positionWorld.copy(ja.positionWorld);g.v1.positionScreen.copy(ea.positionScreen);g.v2.positionScreen.copy(va.positionScreen);g.v3.positionScreen.copy(ja.positionScreen);g.normalWorld.copy(R.normal);aa.multiplyVector3(g.normalWorld);
g.centroidWorld.copy(R.centroid);ta.multiplyVector3(g.centroidWorld);g.centroidScreen.copy(g.centroidWorld);u.multiplyVector3(g.centroidScreen);ja=R.vertexNormals;W=g.vertexNormalsWorld;ea=0;for(va=ja.length;ea<va;ea++){qa=W[ea]=W[ea]||new THREE.Vector3;qa.copy(ja[ea]);aa.multiplyVector3(qa)}g.z=g.centroidScreen.z;g.meshMaterials=ya;g.faceMaterials=R.materials;g.overdraw=ha;if(ga.geometry.uvs[ca]){g.uvs[0]=ga.geometry.uvs[ca][0];g.uvs[1]=ga.geometry.uvs[ca][1];g.uvs[2]=ga.geometry.uvs[ca][2]}T.push(g);
j++}}else if(R instanceof THREE.Face4){ea=na[R.a];va=na[R.b];ja=na[R.c];qa=na[R.d];if(ea.__visible&&va.__visible&&ja.__visible&&qa.__visible&&(ga.doubleSided||ga.flipSided!=((qa.positionScreen.x-ea.positionScreen.x)*(va.positionScreen.y-ea.positionScreen.y)-(qa.positionScreen.y-ea.positionScreen.y)*(va.positionScreen.x-ea.positionScreen.x)<0||(va.positionScreen.x-ja.positionScreen.x)*(qa.positionScreen.y-ja.positionScreen.y)-(va.positionScreen.y-ja.positionScreen.y)*(qa.positionScreen.x-ja.positionScreen.x)<
0))){g=k[j]=k[j]||new THREE.RenderableFace3;g.v1.positionWorld.copy(ea.positionWorld);g.v2.positionWorld.copy(va.positionWorld);g.v3.positionWorld.copy(qa.positionWorld);g.v1.positionScreen.copy(ea.positionScreen);g.v2.positionScreen.copy(va.positionScreen);g.v3.positionScreen.copy(qa.positionScreen);g.normalWorld.copy(R.normal);aa.multiplyVector3(g.normalWorld);g.centroidWorld.copy(R.centroid);ta.multiplyVector3(g.centroidWorld);g.centroidScreen.copy(g.centroidWorld);u.multiplyVector3(g.centroidScreen);
g.z=g.centroidScreen.z;g.meshMaterials=ya;g.faceMaterials=R.materials;g.overdraw=ha;if(ga.geometry.uvs[ca]){g.uvs[0]=ga.geometry.uvs[ca][0];g.uvs[1]=ga.geometry.uvs[ca][1];g.uvs[2]=ga.geometry.uvs[ca][3]}T.push(g);j++;h=k[j]=k[j]||new THREE.RenderableFace3;h.v1.positionWorld.copy(va.positionWorld);h.v2.positionWorld.copy(ja.positionWorld);h.v3.positionWorld.copy(qa.positionWorld);h.v1.positionScreen.copy(va.positionScreen);h.v2.positionScreen.copy(ja.positionScreen);h.v3.positionScreen.copy(qa.positionScreen);
h.normalWorld.copy(g.normalWorld);h.centroidWorld.copy(g.centroidWorld);h.centroidScreen.copy(g.centroidScreen);h.z=h.centroidScreen.z;h.meshMaterials=ya;h.faceMaterials=R.materials;h.overdraw=ha;if(ga.geometry.uvs[ca]){h.uvs[0]=ga.geometry.uvs[ca][1];h.uvs[1]=ga.geometry.uvs[ca][2];h.uvs[2]=ga.geometry.uvs[ca][3]}T.push(h);j++}}}}else if(ga instanceof THREE.Line){E.multiply(u,ta);na=ga.geometry.vertices;R=na[0];R.positionScreen.copy(R.position);E.multiplyVector4(R.positionScreen);ca=1;for(xa=na.length;ca<
xa;ca++){ea=na[ca];ea.positionScreen.copy(ea.position);E.multiplyVector4(ea.positionScreen);va=na[ca-1];M.copy(ea.positionScreen);I.copy(va.positionScreen);if(c(M,I)){M.multiplyScalar(1/M.w);I.multiplyScalar(1/I.w);n=z[t]=z[t]||new THREE.RenderableLine;n.v1.positionScreen.copy(M);n.v2.positionScreen.copy(I);n.z=Math.max(M.z,I.z);n.materials=ga.materials;T.push(n);t++}}}else if(ga instanceof THREE.Particle){B.set(ga.position.x,ga.position.y,ga.position.z,1);u.multiplyVector4(B);B.z/=B.w;if(B.z>0&&
B.z<1){v=w[o]=w[o]||new THREE.RenderableParticle;v.x=B.x/B.w;v.y=B.y/B.w;v.z=B.z;v.rotation=ga.rotation.z;v.scale.x=ga.scale.x*Math.abs(v.x-(B.x+f.projectionMatrix.n11)/(B.w+f.projectionMatrix.n14));v.scale.y=ga.scale.y*Math.abs(v.y-(B.y+f.projectionMatrix.n22)/(B.w+f.projectionMatrix.n24));v.materials=ga.materials;T.push(v);o++}}}}V&&T.sort(a);return T};this.unprojectVector=function(N,f){var V=f.matrixWorld.clone();V.multiplySelf(THREE.Matrix4.makeInvert(f.projectionMatrix));V.multiplyVector3(N);
return N}};
THREE.DOMRenderer=function(){THREE.Renderer.call(this);var a=null,c=new THREE.Projector,b,d,e,g;this.domElement=document.createElement("div");this.setSize=function(h,j){b=h;d=j;e=b/2;g=d/2};this.render=function(h,j){var k,n,t,z,v,o,w,y;a=c.projectScene(h,j);k=0;for(n=a.length;k<n;k++){v=a[k];if(v instanceof THREE.RenderableParticle){w=v.x*e+e;y=v.y*g+g;t=0;for(z=v.material.length;t<z;t++){o=v.material[t];if(o instanceof THREE.ParticleDOMMaterial){o=o.domElement;o.style.left=w+"px";o.style.top=y+"px"}}}}}};
THREE.CanvasRenderer=function(){function a(ka){if(v!=ka)n.globalAlpha=v=ka}function c(ka){if(o!=ka){switch(ka){case THREE.NormalBlending:n.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:n.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:n.globalCompositeOperation="darker"}o=ka}}var b=null,d=new THREE.Projector,e=document.createElement("canvas"),g,h,j,k,n=e.getContext("2d"),t=new THREE.Color(0),z=0,v=1,o=0,w=null,y=null,B=1,u,E,x,M,I,W,N,f,V,T=new THREE.Color,
da=new THREE.Color,fa=new THREE.Color,J=new THREE.Color,ca=new THREE.Color,xa,ea,va,ia,ga,ta,ya,ha,aa,ma=new THREE.Rectangle,na=new THREE.Rectangle,R=new THREE.Rectangle,ja=!1,qa=new THREE.Color,l=new THREE.Color,A=new THREE.Color,q=new THREE.Color,m=Math.PI*2,p=new THREE.Vector3,C,D,G,Q,H,O,la=16;C=document.createElement("canvas");C.width=C.height=2;D=C.getContext("2d");D.fillStyle="rgba(0,0,0,1)";D.fillRect(0,0,2,2);G=D.getImageData(0,0,2,2);Q=G.data;H=document.createElement("canvas");H.width=H.height=
la;O=H.getContext("2d");O.translate(-la/2,-la/2);O.scale(la,la);la--;this.domElement=e;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setSize=function(ka,ra){g=ka;h=ra;j=g/2;k=h/2;e.width=g;e.height=h;ma.set(-j,-k,j,k);v=1;o=0;y=w=null;B=1};this.setClearColor=function(ka,ra){t=ka;z=ra};this.setClearColorHex=function(ka,ra){t.setHex(ka);z=ra};this.clear=function(){n.setTransform(1,0,0,-1,j,k);if(!na.isEmpty()){na.inflate(1);na.minSelf(ma);if(t.hex==0&&z==0)n.clearRect(na.getX(),na.getY(),
na.getWidth(),na.getHeight());else{c(THREE.NormalBlending);a(1);n.fillStyle="rgba("+Math.floor(t.r*255)+","+Math.floor(t.g*255)+","+Math.floor(t.b*255)+","+z+")";n.fillRect(na.getX(),na.getY(),na.getWidth(),na.getHeight())}na.empty()}};this.render=function(ka,ra){function sa(K){var Z,U,L,S=K.lights;l.setRGB(0,0,0);A.setRGB(0,0,0);q.setRGB(0,0,0);K=0;for(Z=S.length;K<Z;K++){U=S[K];L=U.color;if(U instanceof THREE.AmbientLight){l.r+=L.r;l.g+=L.g;l.b+=L.b}else if(U instanceof THREE.DirectionalLight){A.r+=
L.r;A.g+=L.g;A.b+=L.b}else if(U instanceof THREE.PointLight){q.r+=L.r;q.g+=L.g;q.b+=L.b}}}function oa(K,Z,U,L){var S,ua,wa,Ia,za=K.lights;K=0;for(S=za.length;K<S;K++){ua=za[K];wa=ua.color;Ia=ua.intensity;if(ua instanceof THREE.DirectionalLight){ua=U.dot(ua.position)*Ia;if(ua>0){L.r+=wa.r*ua;L.g+=wa.g*ua;L.b+=wa.b*ua}}else if(ua instanceof THREE.PointLight){p.sub(ua.position,Z);p.normalize();ua=U.dot(p)*Ia;if(ua>0){L.r+=wa.r*ua;L.g+=wa.g*ua;L.b+=wa.b*ua}}}}function pa(K,Z,U){if(U.opacity!=0){a(U.opacity);
c(U.blending);var L,S,ua,wa,Ia,za;if(U instanceof THREE.ParticleBasicMaterial){if(U.map){wa=U.map.image;Ia=wa.width>>1;za=wa.height>>1;S=Z.scale.x*j;ua=Z.scale.y*k;U=S*Ia;L=ua*za;R.set(K.x-U,K.y-L,K.x+U,K.y+L);if(ma.instersects(R)){n.save();n.translate(K.x,K.y);n.rotate(-Z.rotation);n.scale(S,-ua);n.translate(-Ia,-za);n.drawImage(wa,0,0);n.restore()}}}else if(U instanceof THREE.ParticleCircleMaterial){if(ja){qa.r=l.r+A.r+q.r;qa.g=l.g+A.g+q.g;qa.b=l.b+A.b+q.b;T.r=U.color.r*qa.r;T.g=U.color.g*qa.g;
T.b=U.color.b*qa.b;T.updateStyleString()}else T.__styleString=U.color.__styleString;U=Z.scale.x*j;L=Z.scale.y*k;R.set(K.x-U,K.y-L,K.x+U,K.y+L);if(ma.instersects(R)){S=T.__styleString;if(y!=S)n.fillStyle=y=S;n.save();n.translate(K.x,K.y);n.rotate(-Z.rotation);n.scale(U,L);n.beginPath();n.arc(0,0,1,0,m,!0);n.closePath();n.fill();n.restore()}}}}function Ja(K,Z,U,L){if(L.opacity!=0){a(L.opacity);c(L.blending);n.beginPath();n.moveTo(K.positionScreen.x,K.positionScreen.y);n.lineTo(Z.positionScreen.x,Z.positionScreen.y);
n.closePath();if(L instanceof THREE.LineBasicMaterial){T.__styleString=L.color.__styleString;K=L.linewidth;if(B!=K)n.lineWidth=B=K;K=T.__styleString;if(w!=K)n.strokeStyle=w=K;n.stroke();R.inflate(L.linewidth*2)}}}function P(K,Z,U,L,S,ua){if(S.opacity!=0){a(S.opacity);c(S.blending);M=K.positionScreen.x;I=K.positionScreen.y;W=Z.positionScreen.x;N=Z.positionScreen.y;f=U.positionScreen.x;V=U.positionScreen.y;n.beginPath();n.moveTo(M,I);n.lineTo(W,N);n.lineTo(f,V);n.lineTo(M,I);n.closePath();if(S instanceof
THREE.MeshBasicMaterial)if(S.map)S.map.mapping instanceof THREE.UVMapping&&Fa(M,I,W,N,f,V,S.map.image,L.uvs[0].u,L.uvs[0].v,L.uvs[1].u,L.uvs[1].v,L.uvs[2].u,L.uvs[2].v);else if(S.envMap){if(S.envMap.mapping instanceof THREE.SphericalReflectionMapping){K=ra.matrixWorldInverse;p.copy(L.vertexNormalsWorld[0]);ia=(p.x*K.n11+p.y*K.n12+p.z*K.n13)*0.5+0.5;ga=-(p.x*K.n21+p.y*K.n22+p.z*K.n23)*0.5+0.5;p.copy(L.vertexNormalsWorld[1]);ta=(p.x*K.n11+p.y*K.n12+p.z*K.n13)*0.5+0.5;ya=-(p.x*K.n21+p.y*K.n22+p.z*K.n23)*
0.5+0.5;p.copy(L.vertexNormalsWorld[2]);ha=(p.x*K.n11+p.y*K.n12+p.z*K.n13)*0.5+0.5;aa=-(p.x*K.n21+p.y*K.n22+p.z*K.n23)*0.5+0.5;Fa(M,I,W,N,f,V,S.envMap.image,ia,ga,ta,ya,ha,aa)}}else S.wireframe?Ga(S.color.__styleString,S.wireframeLinewidth):Ea(S.color.__styleString);else if(S instanceof THREE.MeshLambertMaterial){if(S.map&&!S.wireframe){S.map.mapping instanceof THREE.UVMapping&&Fa(M,I,W,N,f,V,S.map.image,L.uvs[0].u,L.uvs[0].v,L.uvs[1].u,L.uvs[1].v,L.uvs[2].u,L.uvs[2].v);c(THREE.SubtractiveBlending)}if(ja)if(!S.wireframe&&
S.shading==THREE.SmoothShading&&L.vertexNormalsWorld.length==3){da.r=fa.r=J.r=l.r;da.g=fa.g=J.g=l.g;da.b=fa.b=J.b=l.b;oa(ua,L.v1.positionWorld,L.vertexNormalsWorld[0],da);oa(ua,L.v2.positionWorld,L.vertexNormalsWorld[1],fa);oa(ua,L.v3.positionWorld,L.vertexNormalsWorld[2],J);ca.r=(fa.r+J.r)*0.5;ca.g=(fa.g+J.g)*0.5;ca.b=(fa.b+J.b)*0.5;va=X(da,fa,J,ca);Fa(M,I,W,N,f,V,va,0,0,1,0,0,1)}else{qa.r=l.r;qa.g=l.g;qa.b=l.b;oa(ua,L.centroidWorld,L.normalWorld,qa);T.r=S.color.r*qa.r;T.g=S.color.g*qa.g;T.b=S.color.b*
qa.b;T.updateStyleString();S.wireframe?Ga(T.__styleString,S.wireframeLinewidth):Ea(T.__styleString)}else S.wireframe?Ga(S.color.__styleString,S.wireframeLinewidth):Ea(S.color.__styleString)}else if(S instanceof THREE.MeshDepthMaterial){xa=ra.near;ea=ra.far;da.r=da.g=da.b=1-Y(K.positionScreen.z,xa,ea);fa.r=fa.g=fa.b=1-Y(Z.positionScreen.z,xa,ea);J.r=J.g=J.b=1-Y(U.positionScreen.z,xa,ea);ca.r=(fa.r+J.r)*0.5;ca.g=(fa.g+J.g)*0.5;ca.b=(fa.b+J.b)*0.5;va=X(da,fa,J,ca);Fa(M,I,W,N,f,V,va,0,0,1,0,0,1)}else if(S instanceof
THREE.MeshNormalMaterial){T.r=$(L.normalWorld.x);T.g=$(L.normalWorld.y);T.b=$(L.normalWorld.z);T.updateStyleString();S.wireframe?Ga(T.__styleString,S.wireframeLinewidth):Ea(T.__styleString)}}}function Ga(K,Z){if(w!=K)n.strokeStyle=w=K;if(B!=Z)n.lineWidth=B=Z;n.stroke();R.inflate(Z*2)}function Ea(K){if(y!=K)n.fillStyle=y=K;n.fill()}function Fa(K,Z,U,L,S,ua,wa,Ia,za,Pa,Ka,La,Ta){var Na,Qa;Na=wa.width-1;Qa=wa.height-1;Ia*=Na;za*=Qa;Pa*=Na;Ka*=Qa;La*=Na;Ta*=Qa;U-=K;L-=Z;S-=K;ua-=Z;Pa-=Ia;Ka-=za;La-=Ia;
Ta-=za;Na=Pa*Ta-La*Ka;if(Na!=0){Qa=1/Na;Na=(Ta*U-Ka*S)*Qa;Ka=(Ta*L-Ka*ua)*Qa;U=(Pa*S-La*U)*Qa;L=(Pa*ua-La*L)*Qa;K=K-Na*Ia-U*za;Z=Z-Ka*Ia-L*za;n.save();n.transform(Na,Ka,U,L,K,Z);n.clip();n.drawImage(wa,0,0);n.restore()}}function X(K,Z,U,L){var S=~~(K.r*255),ua=~~(K.g*255);K=~~(K.b*255);var wa=~~(Z.r*255),Ia=~~(Z.g*255);Z=~~(Z.b*255);var za=~~(U.r*255),Pa=~~(U.g*255);U=~~(U.b*255);var Ka=~~(L.r*255),La=~~(L.g*255);L=~~(L.b*255);Q[0]=S<0?0:S>255?255:S;Q[1]=ua<0?0:ua>255?255:ua;Q[2]=K<0?0:K>255?255:
K;Q[4]=wa<0?0:wa>255?255:wa;Q[5]=Ia<0?0:Ia>255?255:Ia;Q[6]=Z<0?0:Z>255?255:Z;Q[8]=za<0?0:za>255?255:za;Q[9]=Pa<0?0:Pa>255?255:Pa;Q[10]=U<0?0:U>255?255:U;Q[12]=Ka<0?0:Ka>255?255:Ka;Q[13]=La<0?0:La>255?255:La;Q[14]=L<0?0:L>255?255:L;D.putImageData(G,0,0);O.drawImage(C,0,0);return H}function Y(K,Z,U){K=(K-Z)/(U-Z);return K*K*(3-2*K)}function $(K){K=(K+1)*0.5;return K<0?0:K>1?1:K}function Aa(K,Z){var U=Z.x-K.x,L=Z.y-K.y,S=1/Math.sqrt(U*U+L*L);U*=S;L*=S;Z.x+=U;Z.y+=L;K.x-=U;K.y-=L}var Ha,Da,F,Ca,Ra,Ua,
Ma,Ba;this.autoClear?this.clear():n.setTransform(1,0,0,-1,j,k);b=d.projectScene(ka,ra,this.sortElements);(ja=ka.lights.length>0)&&sa(ka);Ha=0;for(Da=b.length;Ha<Da;Ha++){F=b[Ha];R.empty();if(F instanceof THREE.RenderableParticle){u=F;u.x*=j;u.y*=k;Ca=0;for(Ra=F.materials.length;Ca<Ra;Ca++)pa(u,F,F.materials[Ca],ka)}else if(F instanceof THREE.RenderableLine){u=F.v1;E=F.v2;u.positionScreen.x*=j;u.positionScreen.y*=k;E.positionScreen.x*=j;E.positionScreen.y*=k;R.addPoint(u.positionScreen.x,u.positionScreen.y);
R.addPoint(E.positionScreen.x,E.positionScreen.y);if(ma.instersects(R)){Ca=0;for(Ra=F.materials.length;Ca<Ra;)Ja(u,E,F,F.materials[Ca++],ka)}}else if(F instanceof THREE.RenderableFace3){u=F.v1;E=F.v2;x=F.v3;u.positionScreen.x*=j;u.positionScreen.y*=k;E.positionScreen.x*=j;E.positionScreen.y*=k;x.positionScreen.x*=j;x.positionScreen.y*=k;if(F.overdraw){Aa(u.positionScreen,E.positionScreen);Aa(E.positionScreen,x.positionScreen);Aa(x.positionScreen,u.positionScreen)}R.add3Points(u.positionScreen.x,u.positionScreen.y,
E.positionScreen.x,E.positionScreen.y,x.positionScreen.x,x.positionScreen.y);if(ma.instersects(R)){Ca=0;for(Ra=F.meshMaterials.length;Ca<Ra;){Ba=F.meshMaterials[Ca++];if(Ba instanceof THREE.MeshFaceMaterial){Ua=0;for(Ma=F.faceMaterials.length;Ua<Ma;)(Ba=F.faceMaterials[Ua++])&&P(u,E,x,F,Ba,ka)}else P(u,E,x,F,Ba,ka)}}}na.addRectangle(R)}n.setTransform(1,0,0,1,0,0)}};
THREE.SVGRenderer=function(){function a(ia,ga,ta){var ya,ha,aa,ma;ya=0;for(ha=ia.lights.length;ya<ha;ya++){aa=ia.lights[ya];if(aa instanceof THREE.DirectionalLight){ma=ga.normalWorld.dot(aa.position)*aa.intensity;if(ma>0){ta.r+=aa.color.r*ma;ta.g+=aa.color.g*ma;ta.b+=aa.color.b*ma}}else if(aa instanceof THREE.PointLight){V.sub(aa.position,ga.centroidWorld);V.normalize();ma=ga.normalWorld.dot(V)*aa.intensity;if(ma>0){ta.r+=aa.color.r*ma;ta.g+=aa.color.g*ma;ta.b+=aa.color.b*ma}}}}function c(ia,ga,ta,
ya,ha,aa){J=d(ca++);J.setAttribute("d","M "+ia.positionScreen.x+" "+ia.positionScreen.y+" L "+ga.positionScreen.x+" "+ga.positionScreen.y+" L "+ta.positionScreen.x+","+ta.positionScreen.y+"z");if(ha instanceof THREE.MeshBasicMaterial)x.__styleString=ha.color.__styleString;else if(ha instanceof THREE.MeshLambertMaterial)if(E){M.r=I.r;M.g=I.g;M.b=I.b;a(aa,ya,M);x.r=ha.color.r*M.r;x.g=ha.color.g*M.g;x.b=ha.color.b*M.b;x.updateStyleString()}else x.__styleString=ha.color.__styleString;else if(ha instanceof
THREE.MeshDepthMaterial){f=1-ha.__2near/(ha.__farPlusNear-ya.z*ha.__farMinusNear);x.setRGB(f,f,f)}else ha instanceof THREE.MeshNormalMaterial&&x.setRGB(e(ya.normalWorld.x),e(ya.normalWorld.y),e(ya.normalWorld.z));ha.wireframe?J.setAttribute("style","fill: none; stroke: "+x.__styleString+"; stroke-width: "+ha.wireframeLinewidth+"; stroke-opacity: "+ha.opacity+"; stroke-linecap: "+ha.wireframeLinecap+"; stroke-linejoin: "+ha.wireframeLinejoin):J.setAttribute("style","fill: "+x.__styleString+"; fill-opacity: "+
ha.opacity);j.appendChild(J)}function b(ia,ga,ta,ya,ha,aa,ma){J=d(ca++);J.setAttribute("d","M "+ia.positionScreen.x+" "+ia.positionScreen.y+" L "+ga.positionScreen.x+" "+ga.positionScreen.y+" L "+ta.positionScreen.x+","+ta.positionScreen.y+" L "+ya.positionScreen.x+","+ya.positionScreen.y+"z");if(aa instanceof THREE.MeshBasicMaterial)x.__styleString=aa.color.__styleString;else if(aa instanceof THREE.MeshLambertMaterial)if(E){M.r=I.r;M.g=I.g;M.b=I.b;a(ma,ha,M);x.r=aa.color.r*M.r;x.g=aa.color.g*M.g;
x.b=aa.color.b*M.b;x.updateStyleString()}else x.__styleString=aa.color.__styleString;else if(aa instanceof THREE.MeshDepthMaterial){f=1-aa.__2near/(aa.__farPlusNear-ha.z*aa.__farMinusNear);x.setRGB(f,f,f)}else aa instanceof THREE.MeshNormalMaterial&&x.setRGB(e(ha.normalWorld.x),e(ha.normalWorld.y),e(ha.normalWorld.z));aa.wireframe?J.setAttribute("style","fill: none; stroke: "+x.__styleString+"; stroke-width: "+aa.wireframeLinewidth+"; stroke-opacity: "+aa.opacity+"; stroke-linecap: "+aa.wireframeLinecap+
"; stroke-linejoin: "+aa.wireframeLinejoin):J.setAttribute("style","fill: "+x.__styleString+"; fill-opacity: "+aa.opacity);j.appendChild(J)}function d(ia){if(T[ia]==null){T[ia]=document.createElementNS("http://www.w3.org/2000/svg","path");va==0&&T[ia].setAttribute("shape-rendering","crispEdges")}return T[ia]}function e(ia){return ia<0?Math.min((1+ia)*0.5,0.5):0.5+Math.min(ia*0.5,0.5)}var g=null,h=new THREE.Projector,j=document.createElementNS("http://www.w3.org/2000/svg","svg"),k,n,t,z,v,o,w,y,B=
new THREE.Rectangle,u=new THREE.Rectangle,E=!1,x=new THREE.Color(16777215),M=new THREE.Color(16777215),I=new THREE.Color(0),W=new THREE.Color(0),N=new THREE.Color(0),f,V=new THREE.Vector3,T=[],da=[],fa=[],J,ca,xa,ea,va=1;this.domElement=j;this.autoClear=!0;this.sortObjects=!0;this.sortElements=!0;this.setQuality=function(ia){switch(ia){case "high":va=1;break;case "low":va=0}};this.setSize=function(ia,ga){k=ia;n=ga;t=k/2;z=n/2;j.setAttribute("viewBox",-t+" "+-z+" "+k+" "+n);j.setAttribute("width",
k);j.setAttribute("height",n);B.set(-t,-z,t,z)};this.clear=function(){for(;j.childNodes.length>0;)j.removeChild(j.childNodes[0])};this.render=function(ia,ga){var ta,ya,ha,aa,ma,na,R,ja;this.autoClear&&this.clear();g=h.projectScene(ia,ga,this.sortElements);ea=xa=ca=0;if(E=ia.lights.length>0){R=ia.lights;I.setRGB(0,0,0);W.setRGB(0,0,0);N.setRGB(0,0,0);ta=0;for(ya=R.length;ta<ya;ta++){ha=R[ta];aa=ha.color;if(ha instanceof THREE.AmbientLight){I.r+=aa.r;I.g+=aa.g;I.b+=aa.b}else if(ha instanceof THREE.DirectionalLight){W.r+=
aa.r;W.g+=aa.g;W.b+=aa.b}else if(ha instanceof THREE.PointLight){N.r+=aa.r;N.g+=aa.g;N.b+=aa.b}}}ta=0;for(ya=g.length;ta<ya;ta++){R=g[ta];u.empty();if(R instanceof THREE.RenderableParticle){v=R;v.x*=t;v.y*=-z;ha=0;for(aa=R.materials.length;ha<aa;ha++)if(ja=R.materials[ha]){ma=v;na=R;var qa=xa++;if(da[qa]==null){da[qa]=document.createElementNS("http://www.w3.org/2000/svg","circle");va==0&&da[qa].setAttribute("shape-rendering","crispEdges")}J=da[qa];J.setAttribute("cx",ma.x);J.setAttribute("cy",ma.y);
J.setAttribute("r",na.scale.x*t);if(ja instanceof THREE.ParticleCircleMaterial){if(E){M.r=I.r+W.r+N.r;M.g=I.g+W.g+N.g;M.b=I.b+W.b+N.b;x.r=ja.color.r*M.r;x.g=ja.color.g*M.g;x.b=ja.color.b*M.b;x.updateStyleString()}else x=ja.color;J.setAttribute("style","fill: "+x.__styleString)}j.appendChild(J)}}else if(R instanceof THREE.RenderableLine){v=R.v1;o=R.v2;v.positionScreen.x*=t;v.positionScreen.y*=-z;o.positionScreen.x*=t;o.positionScreen.y*=-z;u.addPoint(v.positionScreen.x,v.positionScreen.y);u.addPoint(o.positionScreen.x,
o.positionScreen.y);if(B.instersects(u)){ha=0;for(aa=R.materials.length;ha<aa;)if(ja=R.materials[ha++]){ma=v;na=o;qa=ea++;if(fa[qa]==null){fa[qa]=document.createElementNS("http://www.w3.org/2000/svg","line");va==0&&fa[qa].setAttribute("shape-rendering","crispEdges")}J=fa[qa];J.setAttribute("x1",ma.positionScreen.x);J.setAttribute("y1",ma.positionScreen.y);J.setAttribute("x2",na.positionScreen.x);J.setAttribute("y2",na.positionScreen.y);if(ja instanceof THREE.LineBasicMaterial){x.__styleString=ja.color.__styleString;
J.setAttribute("style","fill: none; stroke: "+x.__styleString+"; stroke-width: "+ja.linewidth+"; stroke-opacity: "+ja.opacity+"; stroke-linecap: "+ja.linecap+"; stroke-linejoin: "+ja.linejoin);j.appendChild(J)}}}}else if(R instanceof THREE.RenderableFace3){v=R.v1;o=R.v2;w=R.v3;v.positionScreen.x*=t;v.positionScreen.y*=-z;o.positionScreen.x*=t;o.positionScreen.y*=-z;w.positionScreen.x*=t;w.positionScreen.y*=-z;u.addPoint(v.positionScreen.x,v.positionScreen.y);u.addPoint(o.positionScreen.x,o.positionScreen.y);
u.addPoint(w.positionScreen.x,w.positionScreen.y);if(B.instersects(u)){ha=0;for(aa=R.meshMaterials.length;ha<aa;){ja=R.meshMaterials[ha++];if(ja instanceof THREE.MeshFaceMaterial){ma=0;for(na=R.faceMaterials.length;ma<na;)(ja=R.faceMaterials[ma++])&&c(v,o,w,R,ja,ia)}else ja&&c(v,o,w,R,ja,ia)}}}else if(R instanceof THREE.RenderableFace4){v=R.v1;o=R.v2;w=R.v3;y=R.v4;v.positionScreen.x*=t;v.positionScreen.y*=-z;o.positionScreen.x*=t;o.positionScreen.y*=-z;w.positionScreen.x*=t;w.positionScreen.y*=-z;
y.positionScreen.x*=t;y.positionScreen.y*=-z;u.addPoint(v.positionScreen.x,v.positionScreen.y);u.addPoint(o.positionScreen.x,o.positionScreen.y);u.addPoint(w.positionScreen.x,w.positionScreen.y);u.addPoint(y.positionScreen.x,y.positionScreen.y);if(B.instersects(u)){ha=0;for(aa=R.meshMaterials.length;ha<aa;){ja=R.meshMaterials[ha++];if(ja instanceof THREE.MeshFaceMaterial){ma=0;for(na=R.faceMaterials.length;ma<na;)(ja=R.faceMaterials[ma++])&&b(v,o,w,y,R,ja,ia)}else ja&&b(v,o,w,y,R,ja,ia)}}}}}};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",
envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",
envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",
map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv;\n#endif",lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",
lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 pointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\nfloat pointLightWeighting = max( dot( transformedNormal, pointLightVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting;\n#ifdef PHONG\nvPointLightVector[ i ] = pointLightVector;\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec3 vPointLightVector[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( 0.0 );\nvec4 pointSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec3 pointVector = normalize( vPointLightVector[ i ] );\nvec3 pointHalfVector = normalize( vPointLightVector[ i ] + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight;\npointSpecular += mSpecular * pointSpecularWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( 0.0 );\nvec4 dirSpecular = vec4( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif"};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",
value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},normal:{uniforms:{opacity:{type:"f",
value:1}},fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsLib.common,fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,
THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,
THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,"}"].join("\n")},lambert:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",
THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );\ngl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",
THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_vertex,
THREE.ShaderChunk.skinning_vertex,"}"].join("\n")},phong:{uniforms:Uniforms.merge([THREE.UniformsLib.common,THREE.UniformsLib.lights,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",
THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsLib.particle,fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",
THREE.ShaderChunk.color_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;\n}"].join("\n")}};
THREE.WebGLRenderer=function(a){function c(l,A,q){var m,p,C,D=l.vertices,G=D.length,Q=l.colors,H=Q.length,O=l.__vertexArray,la=l.__colorArray,ka=l.__sortArray,ra=l.__dirtyVertices,sa=l.__dirtyColors;if(q.sortParticles){ya.multiplySelf(q.matrixWorld);for(m=0;m<G;m++){p=D[m].position;ma.copy(p);ya.multiplyVector3(ma);ka[m]=[ma.z,m]}ka.sort(function(oa,pa){return pa[0]-oa[0]});for(m=0;m<G;m++){p=D[ka[m][1]].position;C=m*3;O[C]=p.x;O[C+1]=p.y;O[C+2]=p.z}for(m=0;m<H;m++){C=m*3;color=Q[ka[m][1]];la[C]=
color.r;la[C+1]=color.g;la[C+2]=color.b}}else{if(ra)for(m=0;m<G;m++){p=D[m].position;C=m*3;O[C]=p.x;O[C+1]=p.y;O[C+2]=p.z}if(sa)for(m=0;m<H;m++){color=Q[m];C=m*3;la[C]=color.r;la[C+1]=color.g;la[C+2]=color.b}}if(ra||q.sortParticles){f.bindBuffer(f.ARRAY_BUFFER,l.__webGLVertexBuffer);f.bufferData(f.ARRAY_BUFFER,O,A)}if(sa||q.sortParticles){f.bindBuffer(f.ARRAY_BUFFER,l.__webGLColorBuffer);f.bufferData(f.ARRAY_BUFFER,la,A)}}function b(l,A){l.fragmentShader=A.fragmentShader;l.vertexShader=A.vertexShader;
l.uniforms=Uniforms.clone(A.uniforms)}function d(l,A,q,m,p){m.program||da.initMaterial(m,A,q,p);var C=m.program,D=C.uniforms,G=m.uniforms;if(C!=V){f.useProgram(C);V=C}f.uniformMatrix4fv(D.projectionMatrix,!1,ha);if(q&&(m instanceof THREE.MeshBasicMaterial||m instanceof THREE.MeshLambertMaterial||m instanceof THREE.MeshPhongMaterial||m instanceof THREE.LineBasicMaterial||m instanceof THREE.ParticleBasicMaterial)){G.fogColor.value.setHex(q.color.hex);if(q instanceof THREE.Fog){G.fogNear.value=q.near;
G.fogFar.value=q.far}else if(q instanceof THREE.FogExp2)G.fogDensity.value=q.density}if(m instanceof THREE.MeshPhongMaterial||m instanceof THREE.MeshLambertMaterial){var Q,H,O=0,la=0,ka=0,ra,sa,oa,pa=na,Ja=pa.directional.colors,P=pa.directional.positions,Ga=pa.point.colors,Ea=pa.point.positions,Fa=0,X=0;q=H=H=0;for(Q=A.length;q<Q;q++){H=A[q];ra=H.color;sa=H.position;oa=H.intensity;if(H instanceof THREE.AmbientLight){O+=ra.r;la+=ra.g;ka+=ra.b}else if(H instanceof THREE.DirectionalLight){H=Fa*3;Ja[H]=
ra.r*oa;Ja[H+1]=ra.g*oa;Ja[H+2]=ra.b*oa;P[H]=sa.x;P[H+1]=sa.y;P[H+2]=sa.z;Fa+=1}else if(H instanceof THREE.PointLight){H=X*3;Ga[H]=ra.r*oa;Ga[H+1]=ra.g*oa;Ga[H+2]=ra.b*oa;Ea[H]=sa.x;Ea[H+1]=sa.y;Ea[H+2]=sa.z;X+=1}}for(q=Fa*3;q<Ja.length;q++)Ja[q]=0;for(q=X*3;q<Ga.length;q++)Ga[q]=0;pa.point.length=X;pa.directional.length=Fa;pa.ambient[0]=O;pa.ambient[1]=la;pa.ambient[2]=ka;A=na;G.enableLighting.value=A.directional.length+A.point.length;G.ambientLightColor.value=A.ambient;G.directionalLightColor.value=
A.directional.colors;G.directionalLightDirection.value=A.directional.positions;G.pointLightColor.value=A.point.colors;G.pointLightPosition.value=A.point.positions}if(m instanceof THREE.MeshBasicMaterial||m instanceof THREE.MeshLambertMaterial||m instanceof THREE.MeshPhongMaterial){G.diffuse.value.setRGB(m.color.r*m.opacity,m.color.g*m.opacity,m.color.b*m.opacity);G.opacity.value=m.opacity;G.map.texture=m.map;G.lightMap.texture=m.lightMap;G.envMap.texture=m.envMap;G.reflectivity.value=m.reflectivity;
G.refractionRatio.value=m.refractionRatio;G.combine.value=m.combine;G.useRefract.value=m.envMap&&m.envMap.mapping instanceof THREE.CubeRefractionMapping}if(m instanceof THREE.LineBasicMaterial){G.diffuse.value.setRGB(m.color.r*m.opacity,m.color.g*m.opacity,m.color.b*m.opacity);G.opacity.value=m.opacity}else if(m instanceof THREE.ParticleBasicMaterial){G.psColor.value.setRGB(m.color.r*m.opacity,m.color.g*m.opacity,m.color.b*m.opacity);G.opacity.value=m.opacity;G.size.value=m.size;G.scale.value=N.height/
2;G.map.texture=m.map}else if(m instanceof THREE.MeshPhongMaterial){G.ambient.value.setRGB(m.ambient.r,m.ambient.g,m.ambient.b);G.specular.value.setRGB(m.specular.r,m.specular.g,m.specular.b);G.shininess.value=m.shininess}else if(m instanceof THREE.MeshDepthMaterial){G.mNear.value=l.near;G.mFar.value=l.far;G.opacity.value=m.opacity}else if(m instanceof THREE.MeshNormalMaterial)G.opacity.value=m.opacity;for(var Y in G)if(O=C.uniforms[Y]){q=G[Y];Q=q.type;A=q.value;if(Q=="i")f.uniform1i(O,A);else if(Q==
"f")f.uniform1f(O,A);else if(Q=="fv1")f.uniform1fv(O,A);else if(Q=="fv")f.uniform3fv(O,A);else if(Q=="v2")f.uniform2f(O,A.x,A.y);else if(Q=="v3")f.uniform3f(O,A.x,A.y,A.z);else if(Q=="c")f.uniform3f(O,A.r,A.g,A.b);else if(Q=="t"){f.uniform1i(O,A);if(q=q.texture)if(q.image instanceof Array&&q.image.length==6){if(q.image.length==6){if(q.needsUpdate){if(q.__wasSetOnce){f.bindTexture(f.TEXTURE_CUBE_MAP,q.image.__webGLTextureCube);for(Q=0;Q<6;++Q)f.texSubImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+Q,0,0,0,f.RGBA,
f.UNSIGNED_BYTE,q.image[Q])}else{q.image.__webGLTextureCube=f.createTexture();f.bindTexture(f.TEXTURE_CUBE_MAP,q.image.__webGLTextureCube);for(Q=0;Q<6;++Q)f.texImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+Q,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,q.image[Q]);q.__wasSetOnce=!0}E(f.TEXTURE_CUBE_MAP,q,q.image[0]);f.bindTexture(f.TEXTURE_CUBE_MAP,null);q.needsUpdate=!1}f.activeTexture(f.TEXTURE0+A);f.bindTexture(f.TEXTURE_CUBE_MAP,q.image.__webGLTextureCube)}}else{if(q.needsUpdate){if(q.__wasSetOnce){f.bindTexture(f.TEXTURE_2D,
q.__webGLTexture);f.texSubImage2D(f.TEXTURE_2D,0,0,0,f.RGBA,f.UNSIGNED_BYTE,q.image)}else{q.__webGLTexture=f.createTexture();f.bindTexture(f.TEXTURE_2D,q.__webGLTexture);f.texImage2D(f.TEXTURE_2D,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,q.image);q.__wasSetOnce=!0}E(f.TEXTURE_2D,q,q.image);f.bindTexture(f.TEXTURE_2D,null);q.needsUpdate=!1}f.activeTexture(f.TEXTURE0+A);f.bindTexture(f.TEXTURE_2D,q.__webGLTexture)}}}f.uniformMatrix4fv(D.modelViewMatrix,!1,p._modelViewMatrixArray);f.uniformMatrix3fv(D.normalMatrix,
!1,p._normalMatrixArray);(m instanceof THREE.MeshShaderMaterial||m instanceof THREE.MeshPhongMaterial||m.envMap)&&f.uniform3f(D.cameraPosition,l.position.x,l.position.y,l.position.z);(m instanceof THREE.MeshShaderMaterial||m.envMap||m.skinning)&&f.uniformMatrix4fv(D.objectMatrix,!1,p._objectMatrixArray);(m instanceof THREE.MeshPhongMaterial||m instanceof THREE.MeshLambertMaterial||m instanceof THREE.MeshShaderMaterial||m.skinning)&&f.uniformMatrix4fv(D.viewMatrix,!1,aa);if(m.skinning){f.uniformMatrix4fv(D.cameraInverseMatrix,
!1,aa);f.uniformMatrix4fv(D.boneGlobalMatrices,!1,p.boneMatrices)}return C}function e(l,A,q,m,p,C){if(m.opacity!=0){l=d(l,A,q,m,C).attributes;f.bindBuffer(f.ARRAY_BUFFER,p.__webGLVertexBuffer);f.vertexAttribPointer(l.position,3,f.FLOAT,!1,0,0);if(l.color>=0){f.bindBuffer(f.ARRAY_BUFFER,p.__webGLColorBuffer);f.vertexAttribPointer(l.color,3,f.FLOAT,!1,0,0)}if(l.normal>=0){f.bindBuffer(f.ARRAY_BUFFER,p.__webGLNormalBuffer);f.vertexAttribPointer(l.normal,3,f.FLOAT,!1,0,0)}if(l.tangent>=0){f.bindBuffer(f.ARRAY_BUFFER,
p.__webGLTangentBuffer);f.vertexAttribPointer(l.tangent,4,f.FLOAT,!1,0,0)}if(l.uv>=0)if(p.__webGLUVBuffer){f.bindBuffer(f.ARRAY_BUFFER,p.__webGLUVBuffer);f.vertexAttribPointer(l.uv,2,f.FLOAT,!1,0,0);f.enableVertexAttribArray(l.uv)}else f.disableVertexAttribArray(l.uv);if(l.uv2>=0)if(p.__webGLUV2Buffer){f.bindBuffer(f.ARRAY_BUFFER,p.__webGLUV2Buffer);f.vertexAttribPointer(l.uv2,2,f.FLOAT,!1,0,0);f.enableVertexAttribArray(l.uv2)}else f.disableVertexAttribArray(l.uv2);if(m.skinning&&l.skinVertexA>=0&&
l.skinVertexB>=0&&l.skinIndex>=0&&l.skinWeight>=0){f.bindBuffer(f.ARRAY_BUFFER,p.__webGLSkinVertexABuffer);f.vertexAttribPointer(l.skinVertexA,4,f.FLOAT,!1,0,0);f.bindBuffer(f.ARRAY_BUFFER,p.__webGLSkinVertexBBuffer);f.vertexAttribPointer(l.skinVertexB,4,f.FLOAT,!1,0,0);f.bindBuffer(f.ARRAY_BUFFER,p.__webGLSkinIndicesBuffer);f.vertexAttribPointer(l.skinIndex,4,f.FLOAT,!1,0,0);f.bindBuffer(f.ARRAY_BUFFER,p.__webGLSkinWeightsBuffer);f.vertexAttribPointer(l.skinWeight,4,f.FLOAT,!1,0,0)}if(C instanceof
THREE.Mesh)if(m.wireframe){f.lineWidth(m.wireframeLinewidth);f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,p.__webGLLineBuffer);f.drawElements(f.LINES,p.__webGLLineCount,f.UNSIGNED_SHORT,0)}else{f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,p.__webGLFaceBuffer);f.drawElements(f.TRIANGLES,p.__webGLFaceCount,f.UNSIGNED_SHORT,0)}else if(C instanceof THREE.Line){C=C.type==THREE.LineStrip?f.LINE_STRIP:f.LINES;f.lineWidth(m.linewidth);f.drawArrays(C,0,p.__webGLLineCount)}else if(C instanceof THREE.ParticleSystem)f.drawArrays(f.POINTS,
0,p.__webGLParticleCount);else C instanceof THREE.Ribbon&&f.drawArrays(f.TRIANGLE_STRIP,0,p.__webGLVertexCount)}}function g(l,A){if(!l.__webGLVertexBuffer)l.__webGLVertexBuffer=f.createBuffer();if(!l.__webGLNormalBuffer)l.__webGLNormalBuffer=f.createBuffer();if(l.hasPos){f.bindBuffer(f.ARRAY_BUFFER,l.__webGLVertexBuffer);f.bufferData(f.ARRAY_BUFFER,l.positionArray,f.DYNAMIC_DRAW);f.enableVertexAttribArray(A.attributes.position);f.vertexAttribPointer(A.attributes.position,3,f.FLOAT,!1,0,0)}if(l.hasNormal){f.bindBuffer(f.ARRAY_BUFFER,
l.__webGLNormalBuffer);f.bufferData(f.ARRAY_BUFFER,l.normalArray,f.DYNAMIC_DRAW);f.enableVertexAttribArray(A.attributes.normal);f.vertexAttribPointer(A.attributes.normal,3,f.FLOAT,!1,0,0)}f.drawArrays(f.TRIANGLES,0,l.count);l.count=0}function h(l){if(fa!=l.doubleSided){l.doubleSided?f.disable(f.CULL_FACE):f.enable(f.CULL_FACE);fa=l.doubleSided}if(J!=l.flipSided){l.flipSided?f.frontFace(f.CW):f.frontFace(f.CCW);J=l.flipSided}}function j(l){if(xa!=l){l?f.enable(f.DEPTH_TEST):f.disable(f.DEPTH_TEST);
xa=l}}function k(l){ta[0].set(l.n41-l.n11,l.n42-l.n12,l.n43-l.n13,l.n44-l.n14);ta[1].set(l.n41+l.n11,l.n42+l.n12,l.n43+l.n13,l.n44+l.n14);ta[2].set(l.n41+l.n21,l.n42+l.n22,l.n43+l.n23,l.n44+l.n24);ta[3].set(l.n41-l.n21,l.n42-l.n22,l.n43-l.n23,l.n44-l.n24);ta[4].set(l.n41-l.n31,l.n42-l.n32,l.n43-l.n33,l.n44-l.n34);ta[5].set(l.n41+l.n31,l.n42+l.n32,l.n43+l.n33,l.n44+l.n34);var A;for(l=0;l<6;l++){A=ta[l];A.divideScalar(Math.sqrt(A.x*A.x+A.y*A.y+A.z*A.z))}}function n(l){for(var A=l.matrixWorld,q=-l.geometry.boundingSphere.radius*
Math.max(l.scale.x,Math.max(l.scale.y,l.scale.z)),m=0;m<6;m++){l=ta[m].x*A.n14+ta[m].y*A.n24+ta[m].z*A.n34+ta[m].w;if(l<=q)return!1}return!0}function t(l,A){l.list[l.count]=A;l.count+=1}function z(l){var A,q,m=l.object,p=l.opaque,C=l.transparent;C.count=0;l=p.count=0;for(A=m.materials.length;l<A;l++){q=m.materials[l];q.opacity&&q.opacity<1||q.blending!=THREE.NormalBlending?t(C,q):t(p,q)}}function v(l){var A,q,m,p,C=l.object,D=l.buffer,G=l.opaque,Q=l.transparent;Q.count=0;l=G.count=0;for(m=C.materials.length;l<
m;l++){A=C.materials[l];if(A instanceof THREE.MeshFaceMaterial){A=0;for(q=D.materials.length;A<q;A++)(p=D.materials[A])&&(p.opacity&&p.opacity<1||p.blending!=THREE.NormalBlending?t(Q,p):t(G,p))}else{p=A;p.opacity&&p.opacity<1||p.blending!=THREE.NormalBlending?t(Q,p):t(G,p)}}}function o(l,A){return A.z-l.z}function w(l,A){l._modelViewMatrix.multiplyToArray(A.matrixWorldInverse,l.matrixWorld,l._modelViewMatrixArray);THREE.Matrix4.makeInvert3x3(l._modelViewMatrix).transposeIntoArray(l._normalMatrixArray)}
function y(l){function A(la){var ka=[];q=0;for(m=la.length;q<m;q++)la[q]==undefined?ka.push("undefined"):ka.push(la[q].id);return ka.join("_")}var q,m,p,C,D,G,Q,H,O={};l.geometryGroups={};p=0;for(C=l.faces.length;p<C;p++){D=l.faces[p];G=D.materials;Q=A(G);O[Q]==undefined&&(O[Q]={hash:Q,counter:0});H=O[Q].hash+"_"+O[Q].counter;l.geometryGroups[H]==undefined&&(l.geometryGroups[H]={faces:[],materials:G,vertices:0});D=D instanceof THREE.Face3?3:4;if(l.geometryGroups[H].vertices+D>65535){O[Q].counter+=
1;H=O[Q].hash+"_"+O[Q].counter;l.geometryGroups[H]==undefined&&(l.geometryGroups[H]={faces:[],materials:G,vertices:0})}l.geometryGroups[H].faces.push(p);l.geometryGroups[H].vertices+=D}}function B(l,A,q){l.push({buffer:A,object:q,opaque:{list:[],count:0},transparent:{list:[],count:0}})}function u(l){if(l!=ca){switch(l){case THREE.AdditiveBlending:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ONE,f.ONE);break;case THREE.SubtractiveBlending:f.blendFunc(f.DST_COLOR,f.ZERO);break;case THREE.BillboardBlending:f.blendEquation(f.FUNC_ADD);
f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);break;case THREE.ReverseSubtractiveBlending:f.blendEquation(f.FUNC_REVERSE_SUBTRACT);f.blendFunc(f.ONE,f.ONE);break;default:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ONE,f.ONE_MINUS_SRC_ALPHA)}ca=l}}function E(l,A,q){if((q.width&q.width-1)==0&&(q.height&q.height-1)==0){f.texParameteri(l,f.TEXTURE_WRAP_S,W(A.wrapS));f.texParameteri(l,f.TEXTURE_WRAP_T,W(A.wrapT));f.texParameteri(l,f.TEXTURE_MAG_FILTER,W(A.magFilter));f.texParameteri(l,f.TEXTURE_MIN_FILTER,
W(A.minFilter));f.generateMipmap(l)}else{f.texParameteri(l,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE);f.texParameteri(l,f.TEXTURE_WRAP_T,f.CLAMP_TO_EDGE);f.texParameteri(l,f.TEXTURE_MAG_FILTER,I(A.magFilter));f.texParameteri(l,f.TEXTURE_MIN_FILTER,I(A.minFilter))}}function x(l){if(l&&!l.__webGLFramebuffer){l.__webGLFramebuffer=f.createFramebuffer();l.__webGLRenderbuffer=f.createRenderbuffer();l.__webGLTexture=f.createTexture();f.bindRenderbuffer(f.RENDERBUFFER,l.__webGLRenderbuffer);f.renderbufferStorage(f.RENDERBUFFER,
f.DEPTH_COMPONENT16,l.width,l.height);f.bindTexture(f.TEXTURE_2D,l.__webGLTexture);f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_S,W(l.wrapS));f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_T,W(l.wrapT));f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MAG_FILTER,W(l.magFilter));f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MIN_FILTER,W(l.minFilter));f.texImage2D(f.TEXTURE_2D,0,W(l.format),l.width,l.height,0,W(l.format),W(l.type),null);f.bindFramebuffer(f.FRAMEBUFFER,l.__webGLFramebuffer);f.framebufferTexture2D(f.FRAMEBUFFER,
f.COLOR_ATTACHMENT0,f.TEXTURE_2D,l.__webGLTexture,0);f.framebufferRenderbuffer(f.FRAMEBUFFER,f.DEPTH_ATTACHMENT,f.RENDERBUFFER,l.__webGLRenderbuffer);f.bindTexture(f.TEXTURE_2D,null);f.bindRenderbuffer(f.RENDERBUFFER,null);f.bindFramebuffer(f.FRAMEBUFFER,null)}var A,q;if(l){A=l.__webGLFramebuffer;q=l.width;l=l.height}else{A=null;q=ia;l=ga}if(A!=T){f.bindFramebuffer(f.FRAMEBUFFER,A);f.viewport(ea,va,q,l);T=A}}function M(l,A){var q;if(l=="fragment")q=f.createShader(f.FRAGMENT_SHADER);else l=="vertex"&&
(q=f.createShader(f.VERTEX_SHADER));f.shaderSource(q,A);f.compileShader(q);if(!f.getShaderParameter(q,f.COMPILE_STATUS)){alert(f.getShaderInfoLog(q));return null}return q}function I(l){switch(l){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return f.NEAREST;case THREE.LinearFilter:case THREE.LinearMipMapNearestFilter:case THREE.LinearMipMapLinearFilter:return f.LINEAR}}function W(l){switch(l){case THREE.RepeatWrapping:return f.REPEAT;case THREE.ClampToEdgeWrapping:return f.CLAMP_TO_EDGE;
case THREE.MirroredRepeatWrapping:return f.MIRRORED_REPEAT;case THREE.NearestFilter:return f.NEAREST;case THREE.NearestMipMapNearestFilter:return f.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return f.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return f.LINEAR;case THREE.LinearMipMapNearestFilter:return f.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return f.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return f.BYTE;case THREE.UnsignedByteType:return f.UNSIGNED_BYTE;case THREE.ShortType:return f.SHORT;
case THREE.UnsignedShortType:return f.UNSIGNED_SHORT;case THREE.IntType:return f.INT;case THREE.UnsignedShortType:return f.UNSIGNED_INT;case THREE.FloatType:return f.FLOAT;case THREE.AlphaFormat:return f.ALPHA;case THREE.RGBFormat:return f.RGB;case THREE.RGBAFormat:return f.RGBA;case THREE.LuminanceFormat:return f.LUMINANCE;case THREE.LuminanceAlphaFormat:return f.LUMINANCE_ALPHA}return 0}var N=document.createElement("canvas"),f,V=null,T=null,da=this,fa=null,J=null,ca=null,xa=null,ea=0,va=0,ia=0,
ga=0,ta=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],ya=new THREE.Matrix4,ha=new Float32Array(16),aa=new Float32Array(16),ma=new THREE.Vector4,na={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[]}},R=!0,ja=new THREE.Color(0),qa=0;if(a){if(a.antialias!==undefined)R=a.antialias;a.clearColor!==undefined&&ja.setHex(a.clearColor);if(a.clearAlpha!==undefined)qa=a.clearAlpha}this.domElement=
N;this.autoClear=!0;this.sortObjects=!0;(function(l,A,q){try{if(!(f=N.getContext("experimental-webgl",{antialias:l})))throw"Error creating WebGL context.";}catch(m){console.error(m)}f.clearColor(0,0,0,1);f.clearDepth(1);f.enable(f.DEPTH_TEST);f.depthFunc(f.LEQUAL);f.frontFace(f.CCW);f.cullFace(f.BACK);f.enable(f.CULL_FACE);f.enable(f.BLEND);f.blendFunc(f.ONE,f.ONE_MINUS_SRC_ALPHA);f.clearColor(A.r,A.g,A.b,q);_cullEnabled=!0})(R,ja,qa);this.context=f;this.setSize=function(l,A){N.width=l;N.height=A;
this.setViewport(0,0,N.width,N.height)};this.setViewport=function(l,A,q,m){ea=l;va=A;ia=q;ga=m;f.viewport(ea,va,ia,ga)};this.setScissor=function(l,A,q,m){f.scissor(l,A,q,m)};this.enableScissorTest=function(l){l?f.enable(f.SCISSOR_TEST):f.disable(f.SCISSOR_TEST)};this.enableDepthBufferWrite=function(l){f.depthMask(l)};this.setClearColorHex=function(l,A){var q=new THREE.Color(l);f.clearColor(q.r,q.g,q.b,A)};this.setClearColor=function(l,A){f.clearColor(l.r,l.g,l.b,A)};this.clear=function(){f.clear(f.COLOR_BUFFER_BIT|
f.DEPTH_BUFFER_BIT)};this.initMaterial=function(l,A,q,m){var p;if(l instanceof THREE.MeshDepthMaterial)b(l,THREE.ShaderLib.depth);else if(l instanceof THREE.MeshNormalMaterial)b(l,THREE.ShaderLib.normal);else if(l instanceof THREE.MeshBasicMaterial)b(l,THREE.ShaderLib.basic);else if(l instanceof THREE.MeshLambertMaterial)b(l,THREE.ShaderLib.lambert);else if(l instanceof THREE.MeshPhongMaterial)b(l,THREE.ShaderLib.phong);else if(l instanceof THREE.LineBasicMaterial)b(l,THREE.ShaderLib.basic);else l instanceof
THREE.ParticleBasicMaterial&&b(l,THREE.ShaderLib.particle_basic);var C,D,G,Q,H;C=Q=H=0;for(D=A.length;C<D;C++){G=A[C];G instanceof THREE.DirectionalLight&&Q++;G instanceof THREE.PointLight&&H++}if(H+Q<=4)A=Q;else{A=Math.ceil(4*Q/(H+Q));H=4-A}A={directional:A,point:H};C=50;if(m!==undefined&&m instanceof THREE.SkinnedMesh)C=m.bones.length;m=l.fragmentShader;H=l.vertexShader;C={fog:q,map:l.map,envMap:l.envMap,lightMap:l.lightMap,vertexColors:l.vertexColors,sizeAttenuation:l.sizeAttenuation,skinning:l.skinning,
maxDirLights:A.directional,maxPointLights:A.point,maxBones:C};q=f.createProgram();A=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+C.maxDirLights,"#define MAX_POINT_LIGHTS "+C.maxPointLights,C.fog?"#define USE_FOG":"",C.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",C.map?"#define USE_MAP":"",C.envMap?"#define USE_ENVMAP":"",C.lightMap?"#define USE_LIGHTMAP":"",C.vertexColors?"#define USE_COLOR":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");
C=[f.getParameter(f.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+C.maxDirLights,"#define MAX_POINT_LIGHTS "+C.maxPointLights,"#define MAX_BONES "+C.maxBones,C.map?"#define USE_MAP":"",C.envMap?"#define USE_ENVMAP":"",C.lightMap?"#define USE_LIGHTMAP":"",C.vertexColors?"#define USE_COLOR":"",C.skinning?"#define USE_SKINNING":"",C.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec3 color;\nattribute vec2 uv;\nattribute vec2 uv2;\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n"].join("\n");
f.attachShader(q,M("fragment",A+m));f.attachShader(q,M("vertex",C+H));f.linkProgram(q);f.getProgramParameter(q,f.LINK_STATUS)||alert("Could not initialise shaders\nVALIDATE_STATUS: "+f.getProgramParameter(q,f.VALIDATE_STATUS)+", gl error ["+f.getError()+"]");q.uniforms={};q.attributes={};l.program=q;q=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices"];for(p in l.uniforms)q.push(p);p=l.program;m=0;for(H=q.length;m<
H;m++){A=q[m];p.uniforms[A]=f.getUniformLocation(p,A)}p=l.program;q=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];m=0;for(H=q.length;m<H;m++){A=q[m];p.attributes[A]=f.getAttribLocation(p,A)}p=l.program.attributes;f.enableVertexAttribArray(p.position);p.color>=0&&f.enableVertexAttribArray(p.color);p.normal>=0&&f.enableVertexAttribArray(p.normal);p.tangent>=0&&f.enableVertexAttribArray(p.tangent);if(l.skinning&&p.skinVertexA>=0&&p.skinVertexB>=
0&&p.skinIndex>=0&&p.skinWeight>=0){f.enableVertexAttribArray(p.skinVertexA);f.enableVertexAttribArray(p.skinVertexB);f.enableVertexAttribArray(p.skinIndex);f.enableVertexAttribArray(p.skinWeight)}};this.render=function(l,A,q,m){var p,C,D,G,Q,H,O,la,ka=l.lights,ra=l.fog;A.matrixAutoUpdate&&A.updateMatrix();l.update(undefined,!1,A);A.matrixWorldInverse.flattenToArray(aa);A.projectionMatrix.flattenToArray(ha);ya.multiply(A.projectionMatrix,A.matrixWorldInverse);k(ya);this.initWebGLObjects(l);x(q);(this.autoClear||
m)&&this.clear();Q=l.__webglObjects.length;for(m=0;m<Q;m++){p=l.__webglObjects[m];O=p.object;if(O.visible)if(!(O instanceof THREE.Mesh)||n(O)){O.matrixWorld.flattenToArray(O._objectMatrixArray);w(O,A);v(p);p.render=!0;if(this.sortObjects){ma.copy(O.position);ya.multiplyVector3(ma);p.z=ma.z}}else p.render=!1;else p.render=!1}this.sortObjects&&l.__webglObjects.sort(o);H=l.__webglObjectsImmediate.length;for(m=0;m<H;m++){p=l.__webglObjectsImmediate[m];O=p.object;if(O.visible){O.matrixAutoUpdate&&O.matrixWorld.flattenToArray(O._objectMatrixArray);
w(O,A);z(p)}}u(THREE.NormalBlending);for(m=0;m<Q;m++){p=l.__webglObjects[m];if(p.render){O=p.object;la=p.buffer;D=p.opaque;h(O);for(p=0;p<D.count;p++){G=D.list[p];j(G.depthTest);e(A,ka,ra,G,la,O)}}}for(m=0;m<H;m++){p=l.__webglObjectsImmediate[m];O=p.object;if(O.visible){D=p.opaque;h(O);for(p=0;p<D.count;p++){G=D.list[p];j(G.depthTest);C=d(A,ka,ra,G,O);O.render(function(sa){g(sa,C)})}}}for(m=0;m<Q;m++){p=l.__webglObjects[m];if(p.render){O=p.object;la=p.buffer;D=p.transparent;h(O);for(p=0;p<D.count;p++){G=
D.list[p];u(G.blending);j(G.depthTest);e(A,ka,ra,G,la,O)}}}for(m=0;m<H;m++){p=l.__webglObjectsImmediate[m];O=p.object;if(O.visible){D=p.transparent;h(O);for(p=0;p<D.count;p++){G=D.list[p];u(G.blending);j(G.depthTest);C=d(A,ka,ra,G,O);O.render(function(sa){g(sa,C)})}}}if(q&&q.minFilter!==THREE.NearestFilter&&q.minFilter!==THREE.LinearFilter){f.bindTexture(f.TEXTURE_2D,q.__webGLTexture);f.generateMipmap(f.TEXTURE_2D);f.bindTexture(f.TEXTURE_2D,null)}};this.initWebGLObjects=function(l){if(!l.__webglObjects){l.__webglObjects=
[];l.__webglObjectsImmediate=[]}for(;l.__objectsAdded.length;){var A=l.__objectsAdded[0],q=l,m=void 0,p=void 0,C=void 0;if(A._modelViewMatrix==undefined){A._modelViewMatrix=new THREE.Matrix4;A._normalMatrixArray=new Float32Array(9);A._modelViewMatrixArray=new Float32Array(16);A._objectMatrixArray=new Float32Array(16);A.matrixWorld.flattenToArray(A._objectMatrixArray)}if(A instanceof THREE.Mesh){p=A.geometry;p.geometryGroups==undefined&&y(p);for(m in p.geometryGroups){C=p.geometryGroups[m];if(!C.__webGLVertexBuffer){var D=
C;D.__webGLVertexBuffer=f.createBuffer();D.__webGLNormalBuffer=f.createBuffer();D.__webGLTangentBuffer=f.createBuffer();D.__webGLColorBuffer=f.createBuffer();D.__webGLUVBuffer=f.createBuffer();D.__webGLUV2Buffer=f.createBuffer();D.__webGLSkinVertexABuffer=f.createBuffer();D.__webGLSkinVertexBBuffer=f.createBuffer();D.__webGLSkinIndicesBuffer=f.createBuffer();D.__webGLSkinWeightsBuffer=f.createBuffer();D.__webGLFaceBuffer=f.createBuffer();D.__webGLLineBuffer=f.createBuffer();D=C;var G=A,Q=void 0,H=
void 0,O=0,la=0,ka=0,ra=G.geometry.faces,sa=D.faces;Q=0;for(H=sa.length;Q<H;Q++){fi=sa[Q];face=ra[fi];if(face instanceof THREE.Face3){O+=3;la+=1;ka+=3}else if(face instanceof THREE.Face4){O+=4;la+=2;ka+=4}}D.__vertexArray=new Float32Array(O*3);D.__normalArray=new Float32Array(O*3);D.__tangentArray=new Float32Array(O*4);D.__colorArray=new Float32Array(O*3);D.__uvArray=new Float32Array(O*2);D.__uv2Array=new Float32Array(O*2);D.__skinVertexAArray=new Float32Array(O*4);D.__skinVertexBArray=new Float32Array(O*
4);D.__skinIndexArray=new Float32Array(O*4);D.__skinWeightArray=new Float32Array(O*4);D.__faceArray=new Uint16Array(la*3);D.__lineArray=new Uint16Array(ka*2);H=Q=D;O=void 0;ra=void 0;var oa=void 0,pa=void 0;oa=void 0;sa=!1;O=0;for(ra=G.materials.length;O<ra;O++){oa=G.materials[O];if(oa instanceof THREE.MeshFaceMaterial){oa=0;for(pa=H.materials.length;oa<pa;oa++)if(H.materials[oa]&&H.materials[oa].shading!=undefined&&H.materials[oa].shading==THREE.SmoothShading){sa=!0;break}}else if(oa&&oa.shading!=
undefined&&oa.shading==THREE.SmoothShading){sa=!0;break}if(sa)break}Q.__needsSmoothNormals=sa;D.__webGLFaceCount=la*3;D.__webGLLineCount=ka*2;p.__dirtyVertices=!0;p.__dirtyElements=!0;p.__dirtyUvs=!0;p.__dirtyNormals=!0;p.__dirtyTangents=!0;p.__dirtyColors=!0}B(q.__webglObjects,C,A)}}else if(A instanceof THREE.Ribbon){p=A.geometry;if(!p.__webGLVertexBuffer){m=p;m.__webGLVertexBuffer=f.createBuffer();m.__webGLColorBuffer=f.createBuffer();m=p;C=m.vertices.length;m.__vertexArray=new Float32Array(C*3);
m.__colorArray=new Float32Array(C*3);m.__webGLVertexCount=C;p.__dirtyVertices=!0;p.__dirtyColors=!0}B(q.__webglObjects,p,A)}else if(A instanceof THREE.Line){p=A.geometry;if(!p.__webGLVertexBuffer){m=p;m.__webGLVertexBuffer=f.createBuffer();m.__webGLColorBuffer=f.createBuffer();m=p;C=m.vertices.length;m.__vertexArray=new Float32Array(C*3);m.__colorArray=new Float32Array(C*3);m.__webGLLineCount=C;p.__dirtyVertices=!0;p.__dirtyColors=!0}B(q.__webglObjects,p,A)}else if(A instanceof THREE.ParticleSystem){p=
A.geometry;if(!p.__webGLVertexBuffer){m=p;m.__webGLVertexBuffer=f.createBuffer();m.__webGLColorBuffer=f.createBuffer();m=p;C=m.vertices.length;m.__vertexArray=new Float32Array(C*3);m.__colorArray=new Float32Array(C*3);m.__sortArray=[];m.__webGLParticleCount=C;p.__dirtyVertices=!0;p.__dirtyColors=!0}B(q.__webglObjects,p,A)}else THREE.MarchingCubes!==undefined&&A instanceof THREE.MarchingCubes&&q.__webglObjectsImmediate.push({object:A,opaque:{list:[],count:0},transparent:{list:[],count:0}});l.__objectsAdded.splice(0,
1)}for(;l.__objectsRemoved.length;){A=l.__objectsRemoved[0];q=l;p=void 0;m=void 0;for(p=q.__webglObjects.length-1;p>=0;p--){m=q.__webglObjects[p].object;A==m&&q.__webglObjects.splice(p,1)}l.__objectsRemoved.splice(0,1)}A=0;for(q=l.__webglObjects.length;A<q;A++){m=l.__webglObjects[A].object;C=void 0;p=void 0;D=void 0;if(m instanceof THREE.Mesh){p=m.geometry;for(C in p.geometryGroups){D=p.geometryGroups[C];if(p.__dirtyVertices||p.__dirtyElements||p.__dirtyUvs||p.__dirtyNormals||p.__dirtyColors||p.__dirtyTangents){la=
f.DYNAMIC_DRAW;ka=void 0;Q=void 0;var Ja=void 0,P=void 0,Ga=void 0,Ea=void 0,Fa=void 0;Ja=void 0;var X=void 0,Y=void 0,$=void 0,Aa=void 0;X=void 0;Y=void 0;$=void 0;P=void 0;X=void 0;Y=void 0;$=void 0;Aa=void 0;X=void 0;Y=void 0;$=void 0;Aa=void 0;X=void 0;Y=void 0;$=void 0;Aa=void 0;X=void 0;Y=void 0;$=void 0;Aa=void 0;X=void 0;Y=void 0;$=void 0;Aa=void 0;P=void 0;Ea=void 0;Ga=void 0;Fa=void 0;var Ha=pa=oa=sa=ra=O=G=H=0,Da=0,F=0,Ca=D.__vertexArray,Ra=D.__uvArray,Ua=D.__uv2Array,Ma=D.__normalArray,
Ba=D.__tangentArray,K=D.__colorArray,Z=D.__skinVertexAArray,U=D.__skinVertexBArray,L=D.__skinIndexArray,S=D.__skinWeightArray,ua=D.__faceArray,wa=D.__lineArray,Ia=D.__needsSmoothNormals,za=m.geometry,Pa=za.__dirtyVertices,Ka=za.__dirtyElements,La=za.__dirtyUvs,Ta=za.__dirtyNormals,Na=za.__dirtyTangents,Qa=za.__dirtyColors,Oa=za.vertices,Za=D.faces,$a=za.faces,ab=za.uvs,bb=za.uvs2,Sa=za.colors,Wa=za.skinVerticesA,Xa=za.skinVerticesB,Ya=za.skinIndices,Va=za.skinWeights;ka=0;for(Q=Za.length;ka<Q;ka++){Ja=
Za[ka];P=$a[Ja];Fa=ab[Ja];Ja=bb[Ja];Ga=P.vertexNormals;Ea=P.normal;if(P instanceof THREE.Face3){if(Pa){X=Oa[P.a].position;Y=Oa[P.b].position;$=Oa[P.c].position;Ca[G]=X.x;Ca[G+1]=X.y;Ca[G+2]=X.z;Ca[G+3]=Y.x;Ca[G+4]=Y.y;Ca[G+5]=Y.z;Ca[G+6]=$.x;Ca[G+7]=$.y;Ca[G+8]=$.z;G+=9}if(Va.length){X=Va[P.a];Y=Va[P.b];$=Va[P.c];S[F]=X.x;S[F+1]=X.y;S[F+2]=X.z;S[F+3]=X.w;S[F+4]=Y.x;S[F+5]=Y.y;S[F+6]=Y.z;S[F+7]=Y.w;S[F+8]=$.x;S[F+9]=$.y;S[F+10]=$.z;S[F+11]=$.w;X=Ya[P.a];Y=Ya[P.b];$=Ya[P.c];L[F]=X.x;L[F+1]=X.y;L[F+
2]=X.z;L[F+3]=X.w;L[F+4]=Y.x;L[F+5]=Y.y;L[F+6]=Y.z;L[F+7]=Y.w;L[F+8]=$.x;L[F+9]=$.y;L[F+10]=$.z;L[F+11]=$.w;X=Wa[P.a];Y=Wa[P.b];$=Wa[P.c];Z[F]=X.x;Z[F+1]=X.y;Z[F+2]=X.z;Z[F+3]=1;Z[F+4]=Y.x;Z[F+5]=Y.y;Z[F+6]=Y.z;Z[F+7]=1;Z[F+8]=$.x;Z[F+9]=$.y;Z[F+10]=$.z;Z[F+11]=1;X=Xa[P.a];Y=Xa[P.b];$=Xa[P.c];U[F]=X.x;U[F+1]=X.y;U[F+2]=X.z;U[F+3]=1;U[F+4]=Y.x;U[F+5]=Y.y;U[F+6]=Y.z;U[F+7]=1;U[F+8]=$.x;U[F+9]=$.y;U[F+10]=$.z;U[F+11]=1;F+=12}if(Qa&&Sa.length){X=Sa[P.a];Y=Sa[P.b];$=Sa[P.c];K[Da]=X.r;K[Da+1]=X.g;K[Da+
2]=X.b;K[Da+3]=Y.r;K[Da+4]=Y.g;K[Da+5]=Y.b;K[Da+6]=$.r;K[Da+7]=$.g;K[Da+8]=$.b;Da+=9}if(Na&&za.hasTangents){X=Oa[P.a].tangent;Y=Oa[P.b].tangent;$=Oa[P.c].tangent;Ba[pa]=X.x;Ba[pa+1]=X.y;Ba[pa+2]=X.z;Ba[pa+3]=X.w;Ba[pa+4]=Y.x;Ba[pa+5]=Y.y;Ba[pa+6]=Y.z;Ba[pa+7]=Y.w;Ba[pa+8]=$.x;Ba[pa+9]=$.y;Ba[pa+10]=$.z;Ba[pa+11]=$.w;pa+=12}if(Ta)if(Ga.length==3&&Ia)for(P=0;P<3;P++){Ea=Ga[P];Ma[oa]=Ea.x;Ma[oa+1]=Ea.y;Ma[oa+2]=Ea.z;oa+=3}else for(P=0;P<3;P++){Ma[oa]=Ea.x;Ma[oa+1]=Ea.y;Ma[oa+2]=Ea.z;oa+=3}if(La&&Fa)for(P=
0;P<3;P++){Ga=Fa[P];Ra[O]=Ga.u;Ra[O+1]=Ga.v;O+=2}if(La&&Ja)for(P=0;P<3;P++){Fa=Ja[P];Ua[ra]=Fa.u;Ua[ra+1]=Fa.v;ra+=2}if(Ka){ua[sa]=H;ua[sa+1]=H+1;ua[sa+2]=H+2;sa+=3;wa[Ha]=H;wa[Ha+1]=H+1;wa[Ha+2]=H;wa[Ha+3]=H+2;wa[Ha+4]=H+1;wa[Ha+5]=H+2;Ha+=6;H+=3}}else if(P instanceof THREE.Face4){if(Pa){X=Oa[P.a].position;Y=Oa[P.b].position;$=Oa[P.c].position;Aa=Oa[P.d].position;Ca[G]=X.x;Ca[G+1]=X.y;Ca[G+2]=X.z;Ca[G+3]=Y.x;Ca[G+4]=Y.y;Ca[G+5]=Y.z;Ca[G+6]=$.x;Ca[G+7]=$.y;Ca[G+8]=$.z;Ca[G+9]=Aa.x;Ca[G+10]=Aa.y;Ca[G+
11]=Aa.z;G+=12}if(Va.length){X=Va[P.a];Y=Va[P.b];$=Va[P.c];Aa=Va[P.d];S[F]=X.x;S[F+1]=X.y;S[F+2]=X.z;S[F+3]=X.w;S[F+4]=Y.x;S[F+5]=Y.y;S[F+6]=Y.z;S[F+7]=Y.w;S[F+8]=$.x;S[F+9]=$.y;S[F+10]=$.z;S[F+11]=$.w;S[F+12]=Aa.x;S[F+13]=Aa.y;S[F+14]=Aa.z;S[F+15]=Aa.w;X=Ya[P.a];Y=Ya[P.b];$=Ya[P.c];Aa=Ya[P.d];L[F]=X.x;L[F+1]=X.y;L[F+2]=X.z;L[F+3]=X.w;L[F+4]=Y.x;L[F+5]=Y.y;L[F+6]=Y.z;L[F+7]=Y.w;L[F+8]=$.x;L[F+9]=$.y;L[F+10]=$.z;L[F+11]=$.w;L[F+12]=Aa.x;L[F+13]=Aa.y;L[F+14]=Aa.z;L[F+15]=Aa.w;X=Wa[P.a];Y=Wa[P.b];$=
Wa[P.c];Aa=Wa[P.d];Z[F]=X.x;Z[F+1]=X.y;Z[F+2]=X.z;Z[F+3]=1;Z[F+4]=Y.x;Z[F+5]=Y.y;Z[F+6]=Y.z;Z[F+7]=1;Z[F+8]=$.x;Z[F+9]=$.y;Z[F+10]=$.z;Z[F+11]=1;Z[F+12]=Aa.x;Z[F+13]=Aa.y;Z[F+14]=Aa.z;Z[F+15]=1;X=Xa[P.a];Y=Xa[P.b];$=Xa[P.c];Aa=Xa[P.d];U[F]=X.x;U[F+1]=X.y;U[F+2]=X.z;U[F+3]=1;U[F+4]=Y.x;U[F+5]=Y.y;U[F+6]=Y.z;U[F+7]=1;U[F+8]=$.x;U[F+9]=$.y;U[F+10]=$.z;U[F+11]=1;U[F+12]=Aa.x;U[F+13]=Aa.y;U[F+14]=Aa.z;U[F+15]=1;F+=16}if(Qa&&Sa.length){X=Sa[P.a];Y=Sa[P.b];$=Sa[P.c];Aa=Sa[P.d];K[Da]=X.r;K[Da+1]=X.g;K[Da+
2]=X.b;K[Da+3]=Y.r;K[Da+4]=Y.g;K[Da+5]=Y.b;K[Da+6]=$.r;K[Da+7]=$.g;K[Da+8]=$.b;K[Da+9]=Aa.r;K[Da+10]=Aa.g;K[Da+11]=Aa.b;Da+=12}if(Na&&za.hasTangents){X=Oa[P.a].tangent;Y=Oa[P.b].tangent;$=Oa[P.c].tangent;P=Oa[P.d].tangent;Ba[pa]=X.x;Ba[pa+1]=X.y;Ba[pa+2]=X.z;Ba[pa+3]=X.w;Ba[pa+4]=Y.x;Ba[pa+5]=Y.y;Ba[pa+6]=Y.z;Ba[pa+7]=Y.w;Ba[pa+8]=$.x;Ba[pa+9]=$.y;Ba[pa+10]=$.z;Ba[pa+11]=$.w;Ba[pa+12]=P.x;Ba[pa+13]=P.y;Ba[pa+14]=P.z;Ba[pa+15]=P.w;pa+=16}if(Ta)if(Ga.length==4&&Ia)for(P=0;P<4;P++){Ea=Ga[P];Ma[oa]=Ea.x;
Ma[oa+1]=Ea.y;Ma[oa+2]=Ea.z;oa+=3}else for(P=0;P<4;P++){Ma[oa]=Ea.x;Ma[oa+1]=Ea.y;Ma[oa+2]=Ea.z;oa+=3}if(La&&Fa)for(P=0;P<4;P++){Ga=Fa[P];Ra[O]=Ga.u;Ra[O+1]=Ga.v;O+=2}if(La&&Ja)for(P=0;P<4;P++){Fa=Ja[P];Ua[ra]=Fa.u;Ua[ra+1]=Fa.v;ra+=2}if(Ka){ua[sa]=H;ua[sa+1]=H+1;ua[sa+2]=H+2;ua[sa+3]=H;ua[sa+4]=H+2;ua[sa+5]=H+3;sa+=6;wa[Ha]=H;wa[Ha+1]=H+1;wa[Ha+2]=H;wa[Ha+3]=H+3;wa[Ha+4]=H+1;wa[Ha+5]=H+2;wa[Ha+6]=H+2;wa[Ha+7]=H+3;Ha+=8;H+=4}}}if(Pa){f.bindBuffer(f.ARRAY_BUFFER,D.__webGLVertexBuffer);f.bufferData(f.ARRAY_BUFFER,
Ca,la)}if(Qa&&Sa.length){f.bindBuffer(f.ARRAY_BUFFER,D.__webGLColorBuffer);f.bufferData(f.ARRAY_BUFFER,K,la)}if(Ta){f.bindBuffer(f.ARRAY_BUFFER,D.__webGLNormalBuffer);f.bufferData(f.ARRAY_BUFFER,Ma,la)}if(Na&&za.hasTangents){f.bindBuffer(f.ARRAY_BUFFER,D.__webGLTangentBuffer);f.bufferData(f.ARRAY_BUFFER,Ba,la)}if(La&&O>0){f.bindBuffer(f.ARRAY_BUFFER,D.__webGLUVBuffer);f.bufferData(f.ARRAY_BUFFER,Ra,la)}if(La&&ra>0){f.bindBuffer(f.ARRAY_BUFFER,D.__webGLUV2Buffer);f.bufferData(f.ARRAY_BUFFER,Ua,la)}if(Ka){f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,
D.__webGLFaceBuffer);f.bufferData(f.ELEMENT_ARRAY_BUFFER,ua,la);f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,D.__webGLLineBuffer);f.bufferData(f.ELEMENT_ARRAY_BUFFER,wa,la)}if(F>0){f.bindBuffer(f.ARRAY_BUFFER,D.__webGLSkinVertexABuffer);f.bufferData(f.ARRAY_BUFFER,Z,la);f.bindBuffer(f.ARRAY_BUFFER,D.__webGLSkinVertexBBuffer);f.bufferData(f.ARRAY_BUFFER,U,la);f.bindBuffer(f.ARRAY_BUFFER,D.__webGLSkinIndicesBuffer);f.bufferData(f.ARRAY_BUFFER,L,la);f.bindBuffer(f.ARRAY_BUFFER,D.__webGLSkinWeightsBuffer);f.bufferData(f.ARRAY_BUFFER,
S,la)}}}p.__dirtyVertices=!1;p.__dirtyElements=!1;p.__dirtyUvs=!1;p.__dirtyNormals=!1;p.__dirtyTangents=!1;p.__dirtyColors=!1}else if(m instanceof THREE.Ribbon){p=m.geometry;if(p.__dirtyVertices||p.__dirtyColors){m=p;C=f.DYNAMIC_DRAW;H=void 0;H=void 0;G=void 0;D=void 0;O=m.vertices;la=m.colors;ra=O.length;ka=la.length;sa=m.__vertexArray;Q=m.__colorArray;oa=m.__dirtyColors;if(m.__dirtyVertices){for(H=0;H<ra;H++){G=O[H].position;D=H*3;sa[D]=G.x;sa[D+1]=G.y;sa[D+2]=G.z}f.bindBuffer(f.ARRAY_BUFFER,m.__webGLVertexBuffer);
f.bufferData(f.ARRAY_BUFFER,sa,C)}if(oa){for(H=0;H<ka;H++){color=la[H];D=H*3;Q[D]=color.r;Q[D+1]=color.g;Q[D+2]=color.b}f.bindBuffer(f.ARRAY_BUFFER,m.__webGLColorBuffer);f.bufferData(f.ARRAY_BUFFER,Q,C)}}p.__dirtyVertices=!1;p.__dirtyColors=!1}else if(m instanceof THREE.Line){p=m.geometry;if(p.__dirtyVertices||p.__dirtyColors){m=p;C=f.DYNAMIC_DRAW;H=void 0;H=void 0;G=void 0;D=void 0;O=m.vertices;la=m.colors;ra=O.length;ka=la.length;sa=m.__vertexArray;Q=m.__colorArray;oa=m.__dirtyColors;if(m.__dirtyVertices){for(H=
0;H<ra;H++){G=O[H].position;D=H*3;sa[D]=G.x;sa[D+1]=G.y;sa[D+2]=G.z}f.bindBuffer(f.ARRAY_BUFFER,m.__webGLVertexBuffer);f.bufferData(f.ARRAY_BUFFER,sa,C)}if(oa){for(H=0;H<ka;H++){color=la[H];D=H*3;Q[D]=color.r;Q[D+1]=color.g;Q[D+2]=color.b}f.bindBuffer(f.ARRAY_BUFFER,m.__webGLColorBuffer);f.bufferData(f.ARRAY_BUFFER,Q,C)}}p.__dirtyVertices=!1;p.__dirtyColors=!1}else if(m instanceof THREE.ParticleSystem){p=m.geometry;(p.__dirtyVertices||p.__dirtyColors||m.sortParticles)&&c(p,f.DYNAMIC_DRAW,m);p.__dirtyVertices=
!1;p.__dirtyColors=!1}}};this.setFaceCulling=function(l,A){if(l){!A||A=="ccw"?f.frontFace(f.CCW):f.frontFace(f.CW);if(l=="back")f.cullFace(f.BACK);else l=="front"?f.cullFace(f.FRONT):f.cullFace(f.FRONT_AND_BACK);f.enable(f.CULL_FACE)}else f.disable(f.CULL_FACE)};this.supportsVertexTextures=function(){return f.getParameter(f.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0}};
THREE.SoundRenderer=function(){this.volume=1;this.domElement=document.createElement("div");this.domElement.id="THREESound";this.cameraPosition=new THREE.Vector3;this.soundPosition=new THREE.Vector3;this.render=function(a,c,b){b&&a.update(undefined,!1,c);b=a.sounds;var d,e=b.length;for(d=0;d<e;d++){a=b[d];this.soundPosition.set(a.matrixWorld.n14,a.matrixWorld.n24,a.matrixWorld.n34);this.soundPosition.subSelf(c.position);if(a.isPlaying&&a.isLoaded){a.isAddedToDOM||a.addToDOM(this.domElement);a.calculateVolumeAndPan(this.soundPosition)}}}};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableFace3=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.v3=new THREE.Vertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[null,null,null]};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.Vertex;this.v2=new THREE.Vertex;this.materials=null};
var GeometryUtils={merge:function(a,c){var b=c instanceof THREE.Mesh,d=a.vertices.length,e=b?c.geometry:c,g=a.vertices,h=e.vertices,j=a.faces,k=e.faces,n=a.uvs;e=e.uvs;b&&c.matrixAutoUpdate&&c.updateMatrix();for(var t=0,z=h.length;t<z;t++){var v=new THREE.Vertex(h[t].position.clone());b&&c.matrix.multiplyVector3(v.position);g.push(v)}t=0;for(z=k.length;t<z;t++){h=k[t];var o,w=h.vertexNormals;if(h instanceof THREE.Face3)o=new THREE.Face3(h.a+d,h.b+d,h.c+d);else h instanceof THREE.Face4&&(o=new THREE.Face4(h.a+
d,h.b+d,h.c+d,h.d+d));o.centroid.copy(h.centroid);o.normal.copy(h.normal);b=0;for(g=w.length;b<g;b++){v=w[b];o.vertexNormals.push(v.clone())}o.materials=h.materials.slice();j.push(o)}t=0;for(z=e.length;t<z;t++){d=e[t];j=[];b=0;for(g=d.length;b<g;b++)j.push(new THREE.UV(d[b].u,d[b].v));n.push(j)}}},ImageUtils={loadTexture:function(a,c,b){var d=new Image,e=new THREE.Texture(d,c);d.onload=function(){e.needsUpdate=!0;b&&b(this)};d.src=a;return e},loadTextureCube:function(a,c,b){var d,e=[],g=new THREE.Texture(e,
c);c=e.loadCount=0;for(d=a.length;c<d;++c){e[c]=new Image;e[c].onload=function(){e.loadCount+=1;if(e.loadCount==6)g.needsUpdate=!0;b&&b(this)};e[c].src=a[c]}return g}},SceneUtils={loadScene:function(a,c,b,d){a=new Worker(a);a.postMessage(0);a.onmessage=function(e){function g(){for(t in N.objects)if(!J.objects[t]){y=N.objects[t];if(x=J.geometries[y.geometry]){W=[];for(i=0;i<y.materials.length;i++)W[i]=J.materials[y.materials[i]];B=y.position;r=y.rotation;s=y.scale;object=new THREE.Mesh(x,W);object.position.set(B[0],
B[1],B[2]);object.rotation.set(r[0],r[1],r[2]);object.scale.set(s[0],s[1],s[2]);object.visible=y.visible;J.scene.addObject(object);J.objects[t]=object}}}function h(ca){return function(xa){J.geometries[ca]=xa;g();V-=1;j()}}function j(){d({total_models:da,total_textures:fa,loaded_models:da-V,loaded_textures:fa-T},J);V==0&&T==0&&b(J)}var k,n,t,z,v,o,w,y,B,u,E,x,M,I,W,N,f,V,T,da,fa,J;N=e.data;f=new THREE.Loader;T=V=0;J={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},
lights:{},fogs:{}};e=function(){T-=1;j()};for(v in N.cameras){u=N.cameras[v];if(u.type=="perspective")M=new THREE.Camera(u.fov,u.aspect,u.near,u.far);else if(u.type=="ortho"){M=new THREE.Camera;M.projectionMatrix=THREE.Matrix4.makeOrtho(u.left,u.right,u.top,u.bottom,u.near,u.far)}B=u.position;u=u.target;M.position.set(B[0],B[1],B[2]);M.target.position.set(u[0],u[1],u[2]);J.cameras[v]=M}for(z in N.lights){v=N.lights[z];if(v.type=="directional"){B=v.direction;light=new THREE.DirectionalLight;light.position.set(B[0],
B[1],B[2]);light.position.normalize()}else if(v.type=="point"){B=v.position;light=new THREE.PointLight;light.position.set(B[0],B[1],B[2])}u=v.color;i=v.intensity||1;light.color.setRGB(u[0]*i,u[1]*i,u[2]*i);J.scene.addLight(light);J.lights[z]=light}for(o in N.fogs){z=N.fogs[o];if(z.type=="linear")I=new THREE.Fog(0,z.near,z.far);else z.type=="exp2"&&(I=new THREE.FogExp2(0,z.density));u=z.color;I.color.setRGB(u[0],u[1],u[2]);J.fogs[o]=I}if(J.cameras&&N.defaults.camera)J.currentCamera=J.cameras[N.defaults.camera];
if(J.fogs&&N.defaults.fog)J.scene.fog=J.fogs[N.defaults.fog];u=N.defaults.bgcolor;J.bgColor=new THREE.Color;J.bgColor.setRGB(u[0],u[1],u[2]);J.bgColorAlpha=N.defaults.bgalpha;for(k in N.geometries){o=N.geometries[k];if(o.type=="bin_mesh"||o.type=="ascii_mesh")V+=1}da=V;for(k in N.geometries){o=N.geometries[k];if(o.type=="cube"){x=new Cube(o.width,o.height,o.depth,o.segmentsWidth,o.segmentsHeight,o.segmentsDepth,null,o.flipped,o.sides);J.geometries[k]=x}else if(o.type=="plane"){x=new Plane(o.width,
o.height,o.segmentsWidth,o.segmentsHeight);J.geometries[k]=x}else if(o.type=="sphere"){x=new Sphere(o.radius,o.segmentsWidth,o.segmentsHeight);J.geometries[k]=x}else if(o.type=="cylinder"){x=new Cylinder(o.numSegs,o.topRad,o.botRad,o.height,o.topOffset,o.botOffset);J.geometries[k]=x}else if(o.type=="torus"){x=new Torus(o.radius,o.tube,o.segmentsR,o.segmentsT);J.geometries[k]=x}else if(o.type=="icosahedron"){x=new Icosahedron(o.subdivisions);J.geometries[k]=x}else if(o.type=="bin_mesh")f.loadBinary({model:o.url,
callback:h(k)});else o.type=="ascii_mesh"&&f.loadAscii({model:o.url,callback:h(k)})}for(w in N.textures){k=N.textures[w];T+=k.url instanceof Array?k.url.length:1}fa=T;for(w in N.textures){k=N.textures[w];if(k.mapping!=undefined&&THREE[k.mapping]!=undefined)k.mapping=new THREE[k.mapping];if(k.url instanceof Array)o=ImageUtils.loadTextureCube(k.url,k.mapping,e);else{o=ImageUtils.loadTexture(k.url,k.mapping,e);if(THREE[k.minFilter]!=undefined)o.minFilter=THREE[k.minFilter];if(THREE[k.magFilter]!=undefined)o.magFilter=
THREE[k.magFilter]}J.textures[w]=o}for(n in N.materials){w=N.materials[n];for(E in w.parameters)if(E=="envMap"||E=="map"||E=="lightMap")w.parameters[E]=J.textures[w.parameters[E]];else if(E=="shading")w.parameters[E]=w.parameters[E]=="flat"?THREE.FlatShading:THREE.SmoothShading;else if(E=="blending")w.parameters[E]=THREE[w.parameters[E]]?THREE[w.parameters[E]]:THREE.NormalBlending;else E=="combine"&&(w.parameters[E]=w.parameters[E]=="MixOperation"?THREE.MixOperation:THREE.MultiplyOperation);w=new THREE[w.type](w.parameters);
J.materials[n]=w}g();c(J)}},addMesh:function(a,c,b,d,e,g,h,j,k,n){c=new THREE.Mesh(c,n);c.scale.x=c.scale.y=c.scale.z=b;c.position.x=d;c.position.y=e;c.position.z=g;c.rotation.x=h;c.rotation.y=j;c.rotation.z=k;a.addObject(c);return c},addPanoramaCubeWebGL:function(a,c,b){var d=ShaderUtils.lib.cube;d.uniforms.tCube.texture=b;b=new THREE.MeshShaderMaterial({fragmentShader:d.fragmentShader,vertexShader:d.vertexShader,uniforms:d.uniforms});c=new THREE.Mesh(new Cube(c,c,c,1,1,1,null,!0),b);a.addObject(c);
return c},addPanoramaCube:function(a,c,b){var d=[];d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[4])}));d.push(new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));c=new THREE.Mesh(new Cube(c,c,c,1,1,d,!0),new THREE.MeshFaceMaterial);
a.addObject(c);return c},addPanoramaCubePlanes:function(a,c,b){var d=c/2;c=new Plane(c,c);var e=Math.PI,g=Math.PI/2;SceneUtils.addMesh(a,c,1,0,0,-d,0,0,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[5])}));SceneUtils.addMesh(a,c,1,-d,0,0,0,g,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[0])}));SceneUtils.addMesh(a,c,1,d,0,0,0,-g,0,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[1])}));SceneUtils.addMesh(a,c,1,0,d,0,g,0,e,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[2])}));
SceneUtils.addMesh(a,c,1,0,-d,0,-g,0,e,new THREE.MeshBasicMaterial({map:new THREE.Texture(b[3])}))}},ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tNormal:{type:"t",value:2,texture:null},tAO:{type:"t",value:3,texture:null},uNormalScale:{type:"f",value:1},tDisplacement:{type:"t",value:4,texture:null},uDisplacementBias:{type:"f",value:-0.5},uDisplacementScale:{type:"f",value:2.5},uPointLightPos:{type:"v3",value:new THREE.Vector3},uPointLightColor:{type:"c",value:new THREE.Color(15658734)},uDirLightPos:{type:"v3",value:new THREE.Vector3},
uDirLightColor:{type:"c",value:new THREE.Color(15658734)},uAmbientLightColor:{type:"c",value:new THREE.Color(328965)},uDiffuseColor:{type:"c",value:new THREE.Color(15658734)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(328965)},uShininess:{type:"f",value:30}},fragmentShader:"uniform vec3 uDirLightPos;\nuniform vec3 uAmbientLightColor;\nuniform vec3 uDirLightColor;\nuniform vec3 uPointLightColor;\nuniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform bool enableDiffuse;\nuniform bool enableAO;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tAO;\nuniform float uNormalScale;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 diffuseTex = vec3( 1.0, 1.0, 1.0 );\nvec3 aoTex = vec3( 1.0, 1.0, 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse )\ndiffuseTex = texture2D( tDiffuse, vUv ).xyz;\nif( enableAO )\naoTex = texture2D( tAO, vUv ).xyz;\nmat3 tsb = mat3( vTangent, vBinormal, vNormal );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 pointDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 pointSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec3 pointVector = normalize( vPointLightVector );\nvec3 pointHalfVector = normalize( vPointLightVector + vViewPosition );\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, uShininess );\npointDiffuse  += vec4( uDiffuseColor, 1.0 ) * pointDiffuseWeight;\npointSpecular += vec4( uSpecularColor, 1.0 ) * pointSpecularWeight;\nvec4 dirDiffuse  = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 dirSpecular = vec4( 0.0, 0.0, 0.0, 0.0 );\nvec4 lDirection = viewMatrix * vec4( uDirLightPos, 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + vViewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, uShininess );\ndirDiffuse  += vec4( uDiffuseColor, 1.0 ) * dirDiffuseWeight;\ndirSpecular += vec4( uSpecularColor, 1.0 ) * dirSpecularWeight;\nvec4 totalLight = vec4( uAmbientLightColor * uAmbientColor, 1.0 );\ntotalLight += vec4( uDirLightColor, 1.0 ) * ( dirDiffuse + dirSpecular );\ntotalLight += vec4( uPointLightColor, 1.0 ) * ( pointDiffuse + pointSpecular );\ngl_FragColor = vec4( totalLight.xyz * aoTex * diffuseTex, 1.0 );\n}",
vertexShader:"attribute vec4 tangent;\nuniform vec3 uPointLightPos;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nvarying vec3 vPointLightVector;\nvarying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\nvTangent = normalize( normalMatrix * tangent.xyz );\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvBinormal = normalize( vBinormal );\nvUv = uv;\nvec4 lPosition = viewMatrix * vec4( uPointLightPos, 1.0 );\nvPointLightVector = normalize( lPosition.xyz - mvPosition.xyz );\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( vNormal.xyz * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif\n}"},
cube:{uniforms:{tCube:{type:"t",value:1,texture:null}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( - wPos.x, wPos.yz ) );\n}"},convolution:{uniforms:{tDiffuse:{type:"t",
value:0,texture:null},uImageIncrement:{type:"v2",value:new THREE.Vector2(0.001953125,0)},cKernel:{type:"fv1",value:[]}},vertexShader:"varying vec2 vUv;\nuniform vec2 uImageIncrement;\nvoid main(void) {\nvUv = uv - ((KERNEL_SIZE - 1.0) / 2.0) * uImageIncrement;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform vec2 uImageIncrement;\nuniform float cKernel[KERNEL_SIZE];\nvoid main(void) {\nvec2 imageCoord = vUv;\nvec4 sum = vec4( 0.0, 0.0, 0.0, 0.0 );\nfor( int i=0; i<KERNEL_SIZE; ++i ) {\nsum += texture2D( tDiffuse, imageCoord ) * cKernel[i];\nimageCoord += uImageIncrement;\n}\ngl_FragColor = sum;\n}"},
film:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},time:{type:"f",value:0},nIntensity:{type:"f",value:0.5},sIntensity:{type:"f",value:0.05},sCount:{type:"f",value:4096},grayscale:{type:"i",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float time;\nuniform bool grayscale;\nuniform float nIntensity;\nuniform float sIntensity;\nuniform float sCount;\nvoid main() {\nvec4 cTextureScreen = texture2D( tDiffuse, vUv );\nfloat x = vUv.x * vUv.y * time *  1000.0;\nx = mod( x, 13.0 ) * mod( x, 123.0 );\nfloat dx = mod( x, 0.01 );\nvec3 cResult = cTextureScreen.rgb + cTextureScreen.rgb * clamp( 0.1 + dx * 100.0, 0.0, 1.0 );\nvec2 sc = vec2( sin( vUv.y * sCount ), cos( vUv.y * sCount ) );\ncResult += cTextureScreen.rgb * vec3( sc.x, sc.y, sc.x ) * sIntensity;\ncResult = cTextureScreen.rgb + clamp( nIntensity, 0.0,1.0 ) * ( cResult - cTextureScreen.rgb );\nif( grayscale ) {\ncResult = vec3( cResult.r * 0.3 + cResult.g * 0.59 + cResult.b * 0.11 );\n}\ngl_FragColor =  vec4( cResult, cTextureScreen.a );\n}"},
screen:{uniforms:{tDiffuse:{type:"t",value:0,texture:null},opacity:{type:"f",value:1}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"varying vec2 vUv;\nuniform sampler2D tDiffuse;\nuniform float opacity;\nvoid main() {\nvec4 texel = texture2D( tDiffuse, vUv );\ngl_FragColor = opacity * texel;\n}"},basic:{uniforms:{},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0, 0.0, 0.0, 0.5 );\n}"}},buildKernel:function(a){var c,b,d,e,g=2*Math.ceil(a*3)+1;g>25&&(g=25);e=(g-1)*0.5;b=Array(g);for(c=d=0;c<g;++c){b[c]=Math.exp(-((c-e)*(c-e))/(2*a*a));d+=b[c]}for(c=0;c<g;++c)b[c]/=d;return b}},Cube=function(a,c,b,d,e,g,h,j,k){function n(B,u,E,x,M,I,W,N){var f,V,T=d||1,da=e||1,fa=M/2,J=I/2,ca=t.vertices.length;if(B=="x"&&u=="y"||B=="y"&&u=="x")f="z";else if(B=="x"&&u=="z"||B=="z"&&u=="x"){f="y";da=g||1}else if(B=="z"&&
u=="y"||B=="y"&&u=="z"){f="x";T=g||1}var xa=T+1,ea=da+1;M/=T;var va=I/da;for(V=0;V<ea;V++)for(I=0;I<xa;I++){var ia=new THREE.Vector3;ia[B]=(I*M-fa)*E;ia[u]=(V*va-J)*x;ia[f]=W;t.vertices.push(new THREE.Vertex(ia))}for(V=0;V<da;V++)for(I=0;I<T;I++){t.faces.push(new THREE.Face4(I+xa*V+ca,I+xa*(V+1)+ca,I+1+xa*(V+1)+ca,I+1+xa*V+ca,null,N));t.uvs.push([new THREE.UV(I/T,V/da),new THREE.UV(I/T,(V+1)/da),new THREE.UV((I+1)/T,(V+1)/da),new THREE.UV((I+1)/T,V/da)])}}THREE.Geometry.call(this);var t=this,z=a/
2,v=c/2,o=b/2;j=j?-1:1;if(h!==undefined)if(h instanceof Array)this.materials=h;else{this.materials=[];for(var w=0;w<6;w++)this.materials.push([h])}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(k!=undefined)for(var y in k)this.sides[y]!=undefined&&(this.sides[y]=k[y]);this.sides.px&&n("z","y",1*j,-1,b,c,-z,this.materials[0]);this.sides.nx&&n("z","y",-1*j,-1,b,c,z,this.materials[1]);this.sides.py&&n("x","z",1*j,1,a,b,v,this.materials[2]);this.sides.ny&&n("x","z",1*j,-1,
a,b,-v,this.materials[3]);this.sides.pz&&n("x","y",1*j,-1,a,c,o,this.materials[4]);this.sides.nz&&n("x","y",-1*j,-1,a,c,-o,this.materials[5]);(function(){for(var B=[],u=[],E=0,x=t.vertices.length;E<x;E++){for(var M=t.vertices[E],I=!1,W=0,N=B.length;W<N;W++){var f=B[W];if(M.position.x==f.position.x&&M.position.y==f.position.y&&M.position.z==f.position.z){u[E]=W;I=!0;break}}if(!I){u[E]=B.length;B.push(new THREE.Vertex(M.position.clone()))}}E=0;for(x=t.faces.length;E<x;E++){M=t.faces[E];M.a=u[M.a];M.b=
u[M.b];M.c=u[M.c];M.d=u[M.d]}t.vertices=B})();this.computeCentroids();this.computeFaceNormals()};Cube.prototype=new THREE.Geometry;Cube.prototype.constructor=Cube;
var Cylinder=function(a,c,b,d,e){function g(n,t,z){h.vertices.push(new THREE.Vertex(new THREE.Vector3(n,t,z)))}THREE.Geometry.call(this);var h=this,j=Math.PI,k;for(k=0;k<a;k++)g(Math.sin(2*j*k/a)*c,Math.cos(2*j*k/a)*c,0);for(k=0;k<a;k++)g(Math.sin(2*j*k/a)*b,Math.cos(2*j*k/a)*b,d);for(k=0;k<a;k++)h.faces.push(new THREE.Face4(k,k+a,a+(k+1)%a,(k+1)%a));if(b!=0){g(0,0,-e);for(k=a;k<a+a/2;k++)h.faces.push(new THREE.Face4(2*a,(2*k-2*a)%a,(2*k-2*a+1)%a,(2*k-2*a+2)%a))}if(c!=0){g(0,0,d+e);for(k=a+a/2;k<
2*a;k++)h.faces.push(new THREE.Face4((2*k-2*a+2)%a+a,(2*k-2*a+1)%a+a,(2*k-2*a)%a+a,2*a+1))}this.computeCentroids();this.computeFaceNormals()};Cylinder.prototype=new THREE.Geometry;Cylinder.prototype.constructor=Cylinder;
var Plane=function(a,c,b,d){THREE.Geometry.call(this);var e,g=a/2,h=c/2;b=b||1;d=d||1;var j=b+1,k=d+1;a/=b;var n=c/d;for(e=0;e<k;e++)for(c=0;c<j;c++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(c*a-g,-(e*n-h),0)));for(e=0;e<d;e++)for(c=0;c<b;c++){this.faces.push(new THREE.Face4(c+j*e,c+j*(e+1),c+1+j*(e+1),c+1+j*e));this.uvs.push([new THREE.UV(c/b,e/d),new THREE.UV(c/b,(e+1)/d),new THREE.UV((c+1)/b,(e+1)/d),new THREE.UV((c+1)/b,e/d)])}this.computeCentroids();this.computeFaceNormals()};
Plane.prototype=new THREE.Geometry;Plane.prototype.constructor=Plane;
var Sphere=function(a,c,b){THREE.Geometry.call(this);var d,e=Math.PI,g=Math.max(3,c||8),h=Math.max(2,b||6);c=[];for(b=0;b<h+1;b++){d=b/h;var j=a*Math.cos(d*e),k=a*Math.sin(d*e),n=[],t=0;for(d=0;d<g;d++){var z=2*d/g,v=k*Math.sin(z*e);z=k*Math.cos(z*e);(b==0||b==h)&&d>0||(t=this.vertices.push(new THREE.Vertex(new THREE.Vector3(z,j,v)))-1);n.push(t)}c.push(n)}var o,w,y;e=c.length;for(b=0;b<e;b++){g=c[b].length;if(b>0)for(d=0;d<g;d++){n=d==g-1;h=c[b][n?0:d+1];j=c[b][n?g-1:d];k=c[b-1][n?g-1:d];n=c[b-1][n?
0:d+1];v=b/(e-1);o=(b-1)/(e-1);w=(d+1)/g;z=d/g;t=new THREE.UV(1-w,v);v=new THREE.UV(1-z,v);z=new THREE.UV(1-z,o);var B=new THREE.UV(1-w,o);if(b<c.length-1){o=this.vertices[h].position.clone();w=this.vertices[j].position.clone();y=this.vertices[k].position.clone();o.normalize();w.normalize();y.normalize();this.faces.push(new THREE.Face3(h,j,k,[new THREE.Vector3(o.x,o.y,o.z),new THREE.Vector3(w.x,w.y,w.z),new THREE.Vector3(y.x,y.y,y.z)]));this.uvs.push([t,v,z])}if(b>1){o=this.vertices[h].position.clone();
w=this.vertices[k].position.clone();y=this.vertices[n].position.clone();o.normalize();w.normalize();y.normalize();this.faces.push(new THREE.Face3(h,k,n,[new THREE.Vector3(o.x,o.y,o.z),new THREE.Vector3(w.x,w.y,w.z),new THREE.Vector3(y.x,y.y,y.z)]));this.uvs.push([t,z,B])}}}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals();this.boundingSphere={radius:a}};Sphere.prototype=new THREE.Geometry;Sphere.prototype.constructor=Sphere;
var Torus=function(a,c,b,d){this.radius=a||100;this.tube=c||40;this.segmentsR=b||8;this.segmentsT=d||6;a=[];THREE.Geometry.call(this);for(c=0;c<=this.segmentsR;++c)for(b=0;b<=this.segmentsT;++b){d=b/this.segmentsT*2*Math.PI;var e=c/this.segmentsR*2*Math.PI;this.vertices.push(new THREE.Vertex(new THREE.Vector3((this.radius+this.tube*Math.cos(e))*Math.cos(d),(this.radius+this.tube*Math.cos(e))*Math.sin(d),this.tube*Math.sin(e))));a.push([b/this.segmentsT,1-c/this.segmentsR])}for(c=1;c<=this.segmentsR;++c)for(b=
1;b<=this.segmentsT;++b){d=(this.segmentsT+1)*c+b;e=(this.segmentsT+1)*c+b-1;var g=(this.segmentsT+1)*(c-1)+b-1,h=(this.segmentsT+1)*(c-1)+b;this.faces.push(new THREE.Face4(d,e,g,h));this.uvs.push([new THREE.UV(a[d][0],a[d][1]),new THREE.UV(a[e][0],a[e][1]),new THREE.UV(a[g][0],a[g][1]),new THREE.UV(a[h][0],a[h][1])])}delete a;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};Torus.prototype=new THREE.Geometry;Torus.prototype.constructor=Torus;
var Icosahedron=function(a){function c(z,v,o){var w=Math.sqrt(z*z+v*v+o*o);return e.vertices.push(new THREE.Vertex(new THREE.Vector3(z/w,v/w,o/w)))-1}function b(z,v,o,w){w.faces.push(new THREE.Face3(z,v,o))}function d(z,v){var o=e.vertices[z].position,w=e.vertices[v].position;return c((o.x+w.x)/2,(o.y+w.y)/2,(o.z+w.z)/2)}var e=this,g=new THREE.Geometry,h;this.subdivisions=a||0;THREE.Geometry.call(this);a=(1+Math.sqrt(5))/2;c(-1,a,0);c(1,a,0);c(-1,-a,0);c(1,-a,0);c(0,-1,a);c(0,1,a);c(0,-1,-a);c(0,
1,-a);c(a,0,-1);c(a,0,1);c(-a,0,-1);c(-a,0,1);b(0,11,5,g);b(0,5,1,g);b(0,1,7,g);b(0,7,10,g);b(0,10,11,g);b(1,5,9,g);b(5,11,4,g);b(11,10,2,g);b(10,7,6,g);b(7,1,8,g);b(3,9,4,g);b(3,4,2,g);b(3,2,6,g);b(3,6,8,g);b(3,8,9,g);b(4,9,5,g);b(2,4,11,g);b(6,2,10,g);b(8,6,7,g);b(9,8,1,g);for(a=0;a<this.subdivisions;a++){h=new THREE.Geometry;for(var j in g.faces){var k=d(g.faces[j].a,g.faces[j].b),n=d(g.faces[j].b,g.faces[j].c),t=d(g.faces[j].c,g.faces[j].a);b(g.faces[j].a,k,t,h);b(g.faces[j].b,n,k,h);b(g.faces[j].c,
t,n,h);b(k,n,t,h)}g.faces=h.faces}e.faces=g.faces;delete g;delete h;this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};Icosahedron.prototype=new THREE.Geometry;Icosahedron.prototype.constructor=Icosahedron;
function LathedObject(a,c,b){THREE.Geometry.call(this);this.nsteps=c||12;this.latheAngle=b||2*Math.PI;c=this.latheAngle/this.nsteps;for(var d=[],e=[],g=[],h=[],j=0;j<a.length;j++){this.vertices.push(new THREE.Vertex(a[j]));e[j]=this.vertices.length-1;d[j]=new THREE.Vector3(a[j].x,a[j].y,a[j].z)}for(var k=THREE.Matrix4.rotationZMatrix(this.stepSize),n=0;n<=this.latheAngle+0.0010;n+=this.stepSize){for(j=0;j<d.length;j++)if(n<b){d[j]=k.multiplyVector3(d[j].clone());this.vertices.push(new THREE.Vertex(d[j]));
g[j]=this.vertices.length-1}else g=h;n==0&&(h=e);for(j=0;j<e.length-1;j++){this.faces.push(new THREE.Face4(g[j],g[j+1],e[j+1],e[j]));this.uvs.push([new THREE.UV(n/b,j/a.length),new THREE.UV(n/b,(j+1)/a.length),new THREE.UV((n-c)/b,(j+1)/a.length),new THREE.UV((n-c)/b,j/a.length)])}e=g;g=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()}LathedObject.prototype=new THREE.Geometry;LathedObject.prototype.constructor=LathedObject;
if(!window.Int32Array){window.Int32Array=Array;window.Float32Array=Array}
THREE.MarchingCubes=function(a,c){THREE.Object3D.call(this);this.materials=c instanceof Array?c:[c];this.init=function(b){this.isolation=80;this.size=b;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(this.size3*3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=
0;this.hasPos=!1;this.hasNormal=!1;this.positionArray=new Float32Array(this.maxCount*3);this.normalArray=new Float32Array(this.maxCount*3)};this.lerp=function(b,d,e){return b+(d-b)*e};this.VIntX=function(b,d,e,g,h,j,k,n,t,z){h=(h-t)/(z-t);t=this.normal_cache;d[g]=j+h*this.delta;d[g+1]=k;d[g+2]=n;e[g]=this.lerp(t[b],t[b+3],h);e[g+1]=this.lerp(t[b+1],t[b+4],h);e[g+2]=this.lerp(t[b+2],t[b+5],h)};this.VIntY=function(b,d,e,g,h,j,k,n,t,z){h=(h-t)/(z-t);t=this.normal_cache;d[g]=j;d[g+1]=k+h*this.delta;d[g+
2]=n;d=b+this.yd*3;e[g]=this.lerp(t[b],t[d],h);e[g+1]=this.lerp(t[b+1],t[d+1],h);e[g+2]=this.lerp(t[b+2],t[d+2],h)};this.VIntZ=function(b,d,e,g,h,j,k,n,t,z){h=(h-t)/(z-t);t=this.normal_cache;d[g]=j;d[g+1]=k;d[g+2]=n+h*this.delta;d=b+this.zd*3;e[g]=this.lerp(t[b],t[d],h);e[g+1]=this.lerp(t[b+1],t[d+1],h);e[g+2]=this.lerp(t[b+2],t[d+2],h)};this.compNorm=function(b){var d=b*3;if(this.normal_cache[d]==0){this.normal_cache[d]=this.field[b-1]-this.field[b+1];this.normal_cache[d+1]=this.field[b-this.yd]-
this.field[b+this.yd];this.normal_cache[d+2]=this.field[b-this.zd]-this.field[b+this.zd]}};this.polygonize=function(b,d,e,g,h,j){var k=g+1,n=g+this.yd,t=g+this.zd,z=k+this.yd,v=k+this.zd,o=g+this.yd+this.zd,w=k+this.yd+this.zd,y=0,B=this.field[g],u=this.field[k],E=this.field[n],x=this.field[z],M=this.field[t],I=this.field[v],W=this.field[o],N=this.field[w];B<h&&(y|=1);u<h&&(y|=2);E<h&&(y|=8);x<h&&(y|=4);M<h&&(y|=16);I<h&&(y|=32);W<h&&(y|=128);N<h&&(y|=64);var f=THREE.edgeTable[y];if(f==0)return 0;
var V=this.delta,T=b+V,da=d+V;V=e+V;if(f&1){this.compNorm(g);this.compNorm(k);this.VIntX(g*3,this.vlist,this.nlist,0,h,b,d,e,B,u)}if(f&2){this.compNorm(k);this.compNorm(z);this.VIntY(k*3,this.vlist,this.nlist,3,h,T,d,e,u,x)}if(f&4){this.compNorm(n);this.compNorm(z);this.VIntX(n*3,this.vlist,this.nlist,6,h,b,da,e,E,x)}if(f&8){this.compNorm(g);this.compNorm(n);this.VIntY(g*3,this.vlist,this.nlist,9,h,b,d,e,B,E)}if(f&16){this.compNorm(t);this.compNorm(v);this.VIntX(t*3,this.vlist,this.nlist,12,h,b,d,
V,M,I)}if(f&32){this.compNorm(v);this.compNorm(w);this.VIntY(v*3,this.vlist,this.nlist,15,h,T,d,V,I,N)}if(f&64){this.compNorm(o);this.compNorm(w);this.VIntX(o*3,this.vlist,this.nlist,18,h,b,da,V,W,N)}if(f&128){this.compNorm(t);this.compNorm(o);this.VIntY(t*3,this.vlist,this.nlist,21,h,b,d,V,M,W)}if(f&256){this.compNorm(g);this.compNorm(t);this.VIntZ(g*3,this.vlist,this.nlist,24,h,b,d,e,B,M)}if(f&512){this.compNorm(k);this.compNorm(v);this.VIntZ(k*3,this.vlist,this.nlist,27,h,T,d,e,u,I)}if(f&1024){this.compNorm(z);
this.compNorm(w);this.VIntZ(z*3,this.vlist,this.nlist,30,h,T,da,e,x,N)}if(f&2048){this.compNorm(n);this.compNorm(o);this.VIntZ(n*3,this.vlist,this.nlist,33,h,b,da,e,E,W)}y<<=4;for(h=g=0;THREE.triTable[y+h]!=-1;){b=y+h;d=b+1;e=b+2;this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[b],3*THREE.triTable[d],3*THREE.triTable[e],j);h+=3;g++}return g};this.posnormtriv=function(b,d,e,g,h,j){var k=this.count*3;this.positionArray[k]=b[e];this.positionArray[k+1]=b[e+1];this.positionArray[k+2]=b[e+2];this.positionArray[k+
3]=b[g];this.positionArray[k+4]=b[g+1];this.positionArray[k+5]=b[g+2];this.positionArray[k+6]=b[h];this.positionArray[k+7]=b[h+1];this.positionArray[k+8]=b[h+2];this.normalArray[k]=d[e];this.normalArray[k+1]=d[e+1];this.normalArray[k+2]=d[e+2];this.normalArray[k+3]=d[g];this.normalArray[k+4]=d[g+1];this.normalArray[k+5]=d[g+2];this.normalArray[k+6]=d[h];this.normalArray[k+7]=d[h+1];this.normalArray[k+8]=d[h+2];this.hasPos=!0;this.hasNormal=!0;this.count+=3;this.count>=this.maxCount-3&&j(this)};this.begin=
function(){this.count=0;this.hasPos=!1;this.hasNormal=!1};this.end=function(b){if(this.count!=0){for(var d=this.count*3;d<this.positionArray.length;d++)this.positionArray[d]=0;b(this)}};this.addBall=function(b,d,e,g,h){var j=this.size*Math.sqrt(g/h),k=e*this.size,n=d*this.size,t=b*this.size,z=Math.floor(k-j);z<1&&(z=1);k=Math.floor(k+j);k>this.size-1&&(k=this.size-1);var v=Math.floor(n-j);v<1&&(v=1);n=Math.floor(n+j);n>this.size-1&&(n=this.size-1);var o=Math.floor(t-j);o<1&&(o=1);j=Math.floor(t+j);
j>this.size-1&&(j=this.size-1);for(var w,y,B,u,E,x;z<k;z++){t=this.size2*z;y=z/this.size-e;E=y*y;for(y=v;y<n;y++){B=t+this.size*y;w=y/this.size-d;x=w*w;for(w=o;w<j;w++){u=w/this.size-b;u=g/(1.0E-6+u*u+x+E)-h;u>0&&(this.field[B+w]+=u)}}}};this.addPlaneX=function(b,d){var e,g,h,j,k,n=this.size,t=this.yd,z=this.zd,v=this.field,o=n*Math.sqrt(b/d);o>n&&(o=n);for(e=0;e<o;e++){g=e/n;g*=g;j=b/(1.0E-4+g)-d;if(j>0)for(g=0;g<n;g++){k=e+g*t;for(h=0;h<n;h++)v[z*h+k]+=j}}};this.addPlaneY=function(b,d){var e,g,
h,j,k,n,t=this.size,z=this.yd,v=this.zd,o=this.field,w=t*Math.sqrt(b/d);w>t&&(w=t);for(g=0;g<w;g++){e=g/t;e*=e;j=b/(1.0E-4+e)-d;if(j>0){k=g*z;for(e=0;e<t;e++){n=k+e;for(h=0;h<t;h++)o[v*h+n]+=j}}}};this.addPlaneZ=function(b,d){var e,g,h,j,k,n;size=this.size;yd=this.yd;zd=this.zd;field=this.field;dist=size*Math.sqrt(b/d);dist>size&&(dist=size);for(h=0;h<dist;h++){e=h/size;e*=e;j=b/(1.0E-4+e)-d;if(j>0){k=zd*h;for(g=0;g<size;g++){n=k+g*yd;for(e=0;e<size;e++)field[n+e]+=j}}}};this.reset=function(){var b;
for(b=0;b<this.size3;b++){this.normal_cache[b*3]=0;this.field[b]=0}};this.render=function(b){this.begin();var d,e,g,h,j,k,n,t,z,v=this.size-2;for(h=1;h<v;h++){z=this.size2*h;n=(h-this.halfsize)/this.halfsize;for(g=1;g<v;g++){t=z+this.size*g;k=(g-this.halfsize)/this.halfsize;for(e=1;e<v;e++){j=(e-this.halfsize)/this.halfsize;d=t+e;this.polygonize(j,k,n,d,this.isolation,b)}}}this.end(b)};this.generateGeometry=function(){var b=0,d=new THREE.Geometry;this.render(function(e){var g,h,j,k,n,t,z,v;for(g=
0;g<e.count;g++){n=g*3;z=n+1;v=n+2;h=e.positionArray[n];j=e.positionArray[z];k=e.positionArray[v];t=new THREE.Vector3(h,j,k);h=e.normalArray[n];j=e.normalArray[z];k=e.normalArray[v];n=new THREE.Vector3(h,j,k);n.normalize();n=new THREE.Vertex(t,n);d.vertices.push(n)}nfaces=e.count/3;for(g=0;g<nfaces;g++){n=(b+g)*3;z=n+1;v=n+2;t=d.vertices[n].normal;h=d.vertices[z].normal;j=d.vertices[v].normal;n=new THREE.Face3(n,z,v,[t,h,j]);d.faces.push(n)}b+=nfaces;e.count=0});return d};this.init(a)};
THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.QuakeCamera=function(a){function c(b,d){return function(){d.apply(b,arguments)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.movementSpeed=1;this.lookSpeed=0.0050;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.dragToLook=!1;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.domElement=document;if(a){if(a.movementSpeed!==undefined)this.movementSpeed=a.movementSpeed;if(a.lookSpeed!==undefined)this.lookSpeed=a.lookSpeed;if(a.noFly!==undefined)this.noFly=
a.noFly;if(a.lookVertical!==undefined)this.lookVertical=a.lookVertical;if(a.autoForward!==undefined)this.autoForward=a.autoForward;if(a.dragToLook!==undefined)this.dragToLook=a.dragToLook;if(a.heightSpeed!==undefined)this.heightSpeed=a.heightSpeed;if(a.heightCoef!==undefined)this.heightCoef=a.heightCoef;if(a.heightMin!==undefined)this.heightMin=a.heightMin;if(a.heightMax!==undefined)this.heightMax=a.heightMax;if(a.domElement!==undefined)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=
this.mouseY=this.mouseX=this.autoSpeedFactor=0;this.moveForward=!1;this.moveBackward=!1;this.moveLeft=!1;this.moveRight=!1;this.mouseDragOn=!1;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;this.onMouseDown=function(b){b.preventDefault();b.stopPropagation();if(!this.dragToLook)switch(b.button){case 0:this.moveForward=!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(b){b.preventDefault();b.stopPropagation();if(!this.dragToLook)switch(b.button){case 0:this.moveForward=
!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(b){this.mouseX=b.clientX-this.windowHalfX;this.mouseY=b.clientY-this.windowHalfY};this.onKeyDown=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0}};this.onKeyUp=function(b){switch(b.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=
!1;break;case 39:case 68:this.moveRight=!1}};this.update=function(){this.autoSpeedFactor=this.heightSpeed?((this.position.y<this.heightMin?this.heightMin:this.position.y>this.heightMax?this.heightMax:this.position.y)-this.heightMin)*this.heightCoef:0;(this.moveForward||this.autoForward)&&this.translateZ(-(this.movementSpeed+this.autoSpeedFactor));this.moveBackward&&this.translateZ(this.movementSpeed);this.moveLeft&&this.translateX(-this.movementSpeed);this.moveRight&&this.translateX(this.movementSpeed);
var b=this.lookSpeed;this.dragToLook&&!this.mouseDragOn&&(b=0);this.lon+=this.mouseX*b;this.lookVertical&&(this.lat-=this.mouseY*b);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;b=this.target.position;var d=this.position;b.x=d.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=d.y+100*Math.cos(this.phi);b.z=d.z+100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this)};this.domElement.addEventListener("contextmenu",function(b){b.preventDefault()},
!1);this.domElement.addEventListener("mousemove",c(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",c(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",c(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",c(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",c(this,this.onKeyUp),!1)};THREE.QuakeCamera.prototype=new THREE.Camera;THREE.QuakeCamera.prototype.constructor=THREE.QuakeCamera;THREE.QuakeCamera.prototype.supr=THREE.Camera.prototype;
THREE.QuakeCamera.prototype.translate=function(a,c){this.matrix.rotateAxis(c);if(this.noFly)c.y=0;this.position.addSelf(c.multiplyScalar(a));this.target.position.addSelf(c.multiplyScalar(a))};
THREE.PathCamera=function(a){function c(o,w){var y=o[0]-w[0],B=o[1]-w[1],u=o[2]-w[2];return Math.sqrt(y*y+B*B+u*u)}function b(o,w,y,B){var u={name:y,fps:0.6,length:B,hierarchy:[]},E,x,M=w.length,I=g(w),W=0;E=M-1;x={parent:-1,keys:[]};x.keys[0]={time:0,pos:w[0],rot:[0,0,0,1],scl:[1,1,1]};x.keys[E]={time:B,pos:w[E],rot:[0,0,0,1],scl:[1,1,1]};for(E=1;E<M-1;E++){W=B*I.chunks[E]/I.total;x.keys[E]={time:W,pos:w[E]}}u.hierarchy[0]=x;THREE.AnimationHandler.add(u);return new THREE.Animation(o,y,THREE.AnimationHandler.CATMULLROM_FORWARD,
!1)}function d(o){var w,y,B=o.length,u=[];for(w=0;w<B;w++){y=o[w];u[w]={x:y[0],y:y[1],z:y[2]}}return u}function e(o,w){var y,B,u,E,x,M,I=[],W=d(o),N=new THREE.Spline,f=g(o);I.push(o[0]);for(y=1;y<o.length;y++){linearDistance=c(o[y],o[y-1]);realDistance=f.chunks[y]-f.chunks[y-1];M=Math.ceil(w*realDistance/f.total);E=(y-1)/(o.length-1);x=y/(o.length-1);for(B=1;B<M-1;B++){u=E+B*(1/M)*(x-E);position=N.getPoint(W,u);I.push([position.x,position.y,position.z])}I.push(o[y])}return I}function g(o){var w,y=
d(o),B=new THREE.Spline,u=w=w=0,E=[0],x=0,M=[o[0][0],o[0][1],o[0][2]];for(o=1;o<y.length*100;o++){w=o/(y.length*100);position=B.getPoint(y,w);x+=c([position.x,position.y,position.z],M);M=[position.x,position.y,position.z];w*=y.length-1;w=Math.floor(w);if(w!=u){E[w]=x;u=w}}E[E.length]=x;return{chunks:E,total:x}}function h(o,w){var y,B,u=new THREE.Geometry,E=new THREE.Spline,x=d(o);for(y=0;y<x.length*w;y++){B=y/(x.length*w);B=E.getPoint(x,B);u.vertices[y]=new THREE.Vertex(new THREE.Vector3(B.x,B.y,
B.z))}return u}function j(o,w){var y=h(w,10),B=h(w,10),u=new THREE.LineBasicMaterial({color:16711680,linewidth:3});lineObj=new THREE.Line(y,u);particleObj=new THREE.ParticleSystem(B,new THREE.ParticleBasicMaterial({color:16755200,size:3}));lineObj.scale.set(1,1,1);o.addChild(lineObj);particleObj.scale.set(1,1,1);o.addChild(particleObj);B=new Sphere(1,16,8);u=new THREE.MeshBasicMaterial({color:65280});for(i=0;i<w.length;i++){y=new THREE.Mesh(B,u);y.position.set(w[i][0],w[i][1],w[i][2]);y.updateMatrix();
o.addChild(y)}}THREE.Camera.call(this,a.fov,a.aspect,a.near,a.far,a.target);this.id="PathCamera"+THREE.PathCameraIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.0050;this.lookVertical=!0;this.lookHorizontal=!0;this.verticalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};this.horizontalAngleMap={srcRange:[0,6.28],dstRange:[0,6.28]};
this.domElement=document;if(a){if(a.duration!==undefined)this.duration=a.duration*1E3;if(a.waypoints!==undefined)this.waypoints=a.waypoints;if(a.useConstantSpeed!==undefined)this.useConstantSpeed=a.useConstantSpeed;if(a.resamplingCoef!==undefined)this.resamplingCoef=a.resamplingCoef;if(a.createDebugPath!==undefined)this.createDebugPath=a.createDebugPath;if(a.createDebugDummy!==undefined)this.createDebugDummy=a.createDebugDummy;if(a.lookSpeed!==undefined)this.lookSpeed=a.lookSpeed;if(a.lookVertical!==
undefined)this.lookVertical=a.lookVertical;if(a.lookHorizontal!==undefined)this.lookHorizontal=a.lookHorizontal;if(a.verticalAngleMap!==undefined)this.verticalAngleMap=a.verticalAngleMap;if(a.horizontalAngleMap!==undefined)this.horizontalAngleMap=a.horizontalAngleMap;if(a.domElement!==undefined)this.domElement=a.domElement}this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;this.windowHalfX=window.innerWidth/2;this.windowHalfY=window.innerHeight/2;var k=Math.PI*2,n=Math.PI/180;this.update=
function(o,w,y){var B,u;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*n;this.theta=this.lon*n;B=this.phi%k;this.phi=B>=0?B:B+k;B=this.verticalAngleMap.srcRange;u=this.verticalAngleMap.dstRange;this.phi=(this.phi-B[0])*(u[1]-u[0])/(B[1]-B[0])+u[0];B=this.horizontalAngleMap.srcRange;u=this.horizontalAngleMap.dstRange;
this.theta=(this.theta-B[0])*(u[1]-u[0])/(B[1]-B[0])+u[0];B=this.target.position;B.x=100*Math.sin(this.phi)*Math.cos(this.theta);B.y=100*Math.cos(this.phi);B.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.supr.update.call(this,o,w,y)};this.onMouseMove=function(o){this.mouseX=o.clientX-this.windowHalfX;this.mouseY=o.clientY-this.windowHalfY};if(this.useConstantSpeed)this.waypoints=e(this.waypoints,this.resamplingCoef);if(this.createDebugDummy){a=new THREE.MeshLambertMaterial({color:30719});var t=
new THREE.MeshLambertMaterial({color:65280}),z=new Cube(10,10,20),v=new Cube(2,2,10);this.animationParent=new THREE.Mesh(z,a);a=new THREE.Mesh(v,t);a.position.set(0,10,0);this.animation=b(this.animationParent,this.waypoints,this.id,this.duration);this.animationParent.addChild(this);this.animationParent.addChild(this.target);this.animationParent.addChild(a)}else{this.animation=b(this.animationParent,this.waypoints,this.id,this.duration);this.animationParent.addChild(this.target);this.animationParent.addChild(this)}this.createDebugPath&&
j(this.debugPath,this.waypoints);this.domElement.addEventListener("mousemove",function(o,w){return function(){w.apply(o,arguments)}}(this,this.onMouseMove),!1)};THREE.PathCamera.prototype=new THREE.Camera;THREE.PathCamera.prototype.constructor=THREE.PathCamera;THREE.PathCamera.prototype.supr=THREE.Camera.prototype;THREE.PathCameraIdCounter=0;THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?this.addStatusElement():null};
THREE.Loader.prototype={addStatusElement:function(){var a=document.createElement("div");a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="#b00";a.style.color="#fff";a.style.width="140px";a.style.padding="0.25em 0.25em 0.25em 0.5em";a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var c="Loaded ";c+=a.total?(100*a.loaded/a.total).toFixed(0)+"%":(a.loaded/1E3).toFixed(2)+" KB";this.statusDomElement.innerHTML=
c},loadAsciiOld:function(a,c){var b=document.createElement("script");b.type="text/javascript";b.onload=c;b.src=a;document.getElementsByTagName("head")[0].appendChild(b)},loadAscii:function(a){var c=a.model,b=a.callback,d=a.texture_path?a.texture_path:THREE.Loader.prototype.extractUrlbase(c);a=(new Date).getTime();c=new Worker(c);c.onmessage=function(e){THREE.Loader.prototype.createModel(e.data,b,d)};c.postMessage(a)},loadBinary:function(a){var c=a.model,b=a.callback,d=a.texture_path?a.texture_path:
THREE.Loader.prototype.extractUrlbase(c),e=a.bin_path?a.bin_path:THREE.Loader.prototype.extractUrlbase(c);a=(new Date).getTime();c=new Worker(c);var g=this.showProgress?THREE.Loader.prototype.updateProgress:null;c.onmessage=function(h){THREE.Loader.prototype.loadAjaxBuffers(h.data.buffers,h.data.materials,b,e,d,g)};c.onerror=function(h){alert("worker.onerror: "+h.message+"\n"+h.data);h.preventDefault()};c.postMessage(a)},loadAjaxBuffers:function(a,c,b,d,e,g){var h=new XMLHttpRequest,j=d+"/"+a,k=0;
h.onreadystatechange=function(){if(h.readyState==4)h.status==200||h.status==0?THREE.Loader.prototype.createBinModel(h.responseText,b,e,c):alert("Couldn't load ["+j+"] ["+h.status+"]");else if(h.readyState==3){if(g){k==0&&(k=h.getResponseHeader("Content-Length"));g({total:k,loaded:h.responseText.length})}}else h.readyState==2&&(k=h.getResponseHeader("Content-Length"))};h.open("GET",j,!0);h.overrideMimeType("text/plain; charset=x-user-defined");h.setRequestHeader("Content-Type","text/plain");h.send(null)},
createBinModel:function(a,c,b,d){var e=function(g){function h(q,m){var p=t(q,m),C=t(q,m+1),D=t(q,m+2),G=t(q,m+3),Q=(G<<1&255|D>>7)-127;p|=(D&127)<<16|C<<8;if(p==0&&Q==-127)return 0;return(1-2*(G>>7))*(1+p*Math.pow(2,-23))*Math.pow(2,Q)}function j(q,m){var p=t(q,m),C=t(q,m+1),D=t(q,m+2);return(t(q,m+3)<<24)+(D<<16)+(C<<8)+p}function k(q,m){var p=t(q,m);return(t(q,m+1)<<8)+p}function n(q,m){var p=t(q,m);return p>127?p-256:p}function t(q,m){return q.charCodeAt(m)&255}function z(q){var m,p,C;m=j(a,q);
p=j(a,q+W);C=j(a,q+N);q=k(a,q+f);THREE.Loader.prototype.f3(u,m,p,C,q)}function v(q){var m,p,C,D,G,Q;m=j(a,q);p=j(a,q+W);C=j(a,q+N);D=k(a,q+f);G=j(a,q+V);Q=j(a,q+T);q=j(a,q+da);THREE.Loader.prototype.f3n(u,M,m,p,C,D,G,Q,q)}function o(q){var m,p,C,D;m=j(a,q);p=j(a,q+fa);C=j(a,q+J);D=j(a,q+ca);q=k(a,q+xa);THREE.Loader.prototype.f4(u,m,p,C,D,q)}function w(q){var m,p,C,D,G,Q,H,O;m=j(a,q);p=j(a,q+fa);C=j(a,q+J);D=j(a,q+ca);G=k(a,q+xa);Q=j(a,q+ea);H=j(a,q+va);O=j(a,q+ia);q=j(a,q+ga);THREE.Loader.prototype.f4n(u,
M,m,p,C,D,G,Q,H,O,q)}function y(q){var m,p;m=j(a,q);p=j(a,q+ta);q=j(a,q+ya);THREE.Loader.prototype.uv3(u.uvs,I[m*2],I[m*2+1],I[p*2],I[p*2+1],I[q*2],I[q*2+1])}function B(q){var m,p,C;m=j(a,q);p=j(a,q+ha);C=j(a,q+aa);q=j(a,q+ma);THREE.Loader.prototype.uv4(u.uvs,I[m*2],I[m*2+1],I[p*2],I[p*2+1],I[C*2],I[C*2+1],I[q*2],I[q*2+1])}var u=this,E=0,x,M=[],I=[],W,N,f,V,T,da,fa,J,ca,xa,ea,va,ia,ga,ta,ya,ha,aa,ma,na,R,ja,qa,l,A;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(u,d,g);x={signature:a.substr(E,
8),header_bytes:t(a,E+8),vertex_coordinate_bytes:t(a,E+9),normal_coordinate_bytes:t(a,E+10),uv_coordinate_bytes:t(a,E+11),vertex_index_bytes:t(a,E+12),normal_index_bytes:t(a,E+13),uv_index_bytes:t(a,E+14),material_index_bytes:t(a,E+15),nvertices:j(a,E+16),nnormals:j(a,E+16+4),nuvs:j(a,E+16+8),ntri_flat:j(a,E+16+12),ntri_smooth:j(a,E+16+16),ntri_flat_uv:j(a,E+16+20),ntri_smooth_uv:j(a,E+16+24),nquad_flat:j(a,E+16+28),nquad_smooth:j(a,E+16+32),nquad_flat_uv:j(a,E+16+36),nquad_smooth_uv:j(a,E+16+40)};
E+=x.header_bytes;W=x.vertex_index_bytes;N=x.vertex_index_bytes*2;f=x.vertex_index_bytes*3;V=x.vertex_index_bytes*3+x.material_index_bytes;T=x.vertex_index_bytes*3+x.material_index_bytes+x.normal_index_bytes;da=x.vertex_index_bytes*3+x.material_index_bytes+x.normal_index_bytes*2;fa=x.vertex_index_bytes;J=x.vertex_index_bytes*2;ca=x.vertex_index_bytes*3;xa=x.vertex_index_bytes*4;ea=x.vertex_index_bytes*4+x.material_index_bytes;va=x.vertex_index_bytes*4+x.material_index_bytes+x.normal_index_bytes;ia=
x.vertex_index_bytes*4+x.material_index_bytes+x.normal_index_bytes*2;ga=x.vertex_index_bytes*4+x.material_index_bytes+x.normal_index_bytes*3;ta=x.uv_index_bytes;ya=x.uv_index_bytes*2;ha=x.uv_index_bytes;aa=x.uv_index_bytes*2;ma=x.uv_index_bytes*3;g=x.vertex_index_bytes*3+x.material_index_bytes;A=x.vertex_index_bytes*4+x.material_index_bytes;na=x.ntri_flat*g;R=x.ntri_smooth*(g+x.normal_index_bytes*3);ja=x.ntri_flat_uv*(g+x.uv_index_bytes*3);qa=x.ntri_smooth_uv*(g+x.normal_index_bytes*3+x.uv_index_bytes*
3);l=x.nquad_flat*A;g=x.nquad_smooth*(A+x.normal_index_bytes*4);A=x.nquad_flat_uv*(A+x.uv_index_bytes*4);E+=function(q){for(var m,p,C,D=x.vertex_coordinate_bytes*3,G=q+x.nvertices*D;q<G;q+=D){m=h(a,q);p=h(a,q+x.vertex_coordinate_bytes);C=h(a,q+x.vertex_coordinate_bytes*2);THREE.Loader.prototype.v(u,m,p,C)}return x.nvertices*D}(E);E+=function(q){for(var m,p,C,D=x.normal_coordinate_bytes*3,G=q+x.nnormals*D;q<G;q+=D){m=n(a,q);p=n(a,q+x.normal_coordinate_bytes);C=n(a,q+x.normal_coordinate_bytes*2);M.push(m/
127,p/127,C/127)}return x.nnormals*D}(E);E+=function(q){for(var m,p,C=x.uv_coordinate_bytes*2,D=q+x.nuvs*C;q<D;q+=C){m=h(a,q);p=h(a,q+x.uv_coordinate_bytes);I.push(m,p)}return x.nuvs*C}(E);na=E+na;R=na+R;ja=R+ja;qa=ja+qa;l=qa+l;g=l+g;A=g+A;(function(q){var m,p=x.vertex_index_bytes*3+x.material_index_bytes,C=p+x.uv_index_bytes*3,D=q+x.ntri_flat_uv*C;for(m=q;m<D;m+=C){z(m);y(m+p)}return D-q})(R);(function(q){var m,p=x.vertex_index_bytes*3+x.material_index_bytes+x.normal_index_bytes*3,C=p+x.uv_index_bytes*
3,D=q+x.ntri_smooth_uv*C;for(m=q;m<D;m+=C){v(m);y(m+p)}return D-q})(ja);(function(q){var m,p=x.vertex_index_bytes*4+x.material_index_bytes,C=p+x.uv_index_bytes*4,D=q+x.nquad_flat_uv*C;for(m=q;m<D;m+=C){o(m);B(m+p)}return D-q})(g);(function(q){var m,p=x.vertex_index_bytes*4+x.material_index_bytes+x.normal_index_bytes*4,C=p+x.uv_index_bytes*4,D=q+x.nquad_smooth_uv*C;for(m=q;m<D;m+=C){w(m);B(m+p)}return D-q})(A);(function(q){var m,p=x.vertex_index_bytes*3+x.material_index_bytes,C=q+x.ntri_flat*p;for(m=
q;m<C;m+=p)z(m);return C-q})(E);(function(q){var m,p=x.vertex_index_bytes*3+x.material_index_bytes+x.normal_index_bytes*3,C=q+x.ntri_smooth*p;for(m=q;m<C;m+=p)v(m);return C-q})(na);(function(q){var m,p=x.vertex_index_bytes*4+x.material_index_bytes,C=q+x.nquad_flat*p;for(m=q;m<C;m+=p)o(m);return C-q})(qa);(function(q){var m,p=x.vertex_index_bytes*4+x.material_index_bytes+x.normal_index_bytes*4,C=q+x.nquad_smooth*p;for(m=q;m<C;m+=p)w(m);return C-q})(l);this.computeCentroids();this.computeFaceNormals()};
e.prototype=new THREE.Geometry;e.prototype.constructor=e;c(new e(b))},createModel:function(a,c,b){var d=function(e){var g=this;THREE.Geometry.call(this);THREE.Loader.prototype.init_materials(g,a.materials,e);(function(){var h,j,k,n,t;h=0;for(j=a.vertices.length;h<j;h+=3){k=a.vertices[h];n=a.vertices[h+1];t=a.vertices[h+2];THREE.Loader.prototype.v(g,k,n,t)}if(a.colors){h=0;for(j=a.colors.length;h<j;h+=3){k=a.colors[h];n=a.colors[h+1];t=a.colors[h+2];THREE.Loader.prototype.vc(g,k,n,t)}}})();(function(){function h(w,
y){THREE.Loader.prototype.f3(g,w[y],w[y+1],w[y+2],w[y+3])}function j(w,y){THREE.Loader.prototype.f3n(g,a.normals,w[y],w[y+1],w[y+2],w[y+3],w[y+4],w[y+5],w[y+6])}function k(w,y){THREE.Loader.prototype.f4(g,w[y],w[y+1],w[y+2],w[y+3],w[y+4])}function n(w,y){THREE.Loader.prototype.f4n(g,a.normals,w[y],w[y+1],w[y+2],w[y+3],w[y+4],w[y+5],w[y+6],w[y+7],w[y+8])}function t(w,y){var B,u,E,x,M,I,W,N,f;B=w[y];u=w[y+1];E=w[y+2];x=a.uvs[B*2];W=a.uvs[B*2+1];M=a.uvs[u*2];N=a.uvs[u*2+1];I=a.uvs[E*2];f=a.uvs[E*2+1];
THREE.Loader.prototype.uv3(g.uvs,x,W,M,N,I,f);if(a.uvs2&&a.uvs2.length){x=a.uvs2[B*2];W=a.uvs2[B*2+1];M=a.uvs2[u*2];N=a.uvs2[u*2+1];I=a.uvs2[E*2];f=a.uvs2[E*2+1];THREE.Loader.prototype.uv3(g.uvs2,x,1-W,M,1-N,I,1-f)}}function z(w,y){var B,u,E,x,M,I,W,N,f,V,T,da;B=w[y];u=w[y+1];E=w[y+2];x=w[y+3];M=a.uvs[B*2];f=a.uvs[B*2+1];I=a.uvs[u*2];V=a.uvs[u*2+1];W=a.uvs[E*2];T=a.uvs[E*2+1];N=a.uvs[x*2];da=a.uvs[x*2+1];THREE.Loader.prototype.uv4(g.uvs,M,f,I,V,W,T,N,da);if(a.uvs2){M=a.uvs2[B*2];f=a.uvs2[B*2+1];I=
a.uvs2[u*2];V=a.uvs2[u*2+1];W=a.uvs2[E*2];T=a.uvs2[E*2+1];N=a.uvs2[x*2];da=a.uvs2[x*2+1];THREE.Loader.prototype.uv4(g.uvs2,M,1-f,I,1-V,W,1-T,N,1-da)}}var v,o;v=0;for(o=a.trianglesUvs.length;v<o;v+=7){h(a.trianglesUvs,v);t(a.trianglesUvs,v+4)}v=0;for(o=a.trianglesNormalsUvs.length;v<o;v+=10){j(a.trianglesNormalsUvs,v);t(a.trianglesNormalsUvs,v+7)}v=0;for(o=a.quadsUvs.length;v<o;v+=9){k(a.quadsUvs,v);z(a.quadsUvs,v+5)}v=0;for(o=a.quadsNormalsUvs.length;v<o;v+=13){n(a.quadsNormalsUvs,v);z(a.quadsNormalsUvs,
v+9)}v=0;for(o=a.triangles.length;v<o;v+=4)h(a.triangles,v);v=0;for(o=a.trianglesNormals.length;v<o;v+=7)j(a.trianglesNormals,v);v=0;for(o=a.quads.length;v<o;v+=5)k(a.quads,v);v=0;for(o=a.quadsNormals.length;v<o;v+=9)n(a.quadsNormals,v)})();(function(){var h,j,k,n;if(a.skinWeights){h=0;for(j=a.skinWeights.length;h<j;h+=2){k=a.skinWeights[h];n=a.skinWeights[h+1];THREE.Loader.prototype.sw(g,k,n,0,0)}}if(a.skinIndices){h=0;for(j=a.skinIndices.length;h<j;h+=2){k=a.skinIndices[h];n=a.skinIndices[h+1];
THREE.Loader.prototype.si(g,k,n,0,0)}}THREE.Loader.prototype.bones(g,a.bones);THREE.Loader.prototype.animation(g,a.animation)})();this.computeCentroids();this.computeFaceNormals()};d.prototype=new THREE.Geometry;d.prototype.constructor=d;c(new d(b))},bones:function(a,c){a.bones=c},animation:function(a,c){a.animation=c},si:function(a,c,b,d,e){a.skinIndices.push(new THREE.Vector4(c,b,d,e))},sw:function(a,c,b,d,e){a.skinWeights.push(new THREE.Vector4(c,b,d,e))},v:function(a,c,b,d){a.vertices.push(new THREE.Vertex(new THREE.Vector3(c,
b,d)))},vc:function(a,c,b,d){var e=new THREE.Color(16777215);e.setRGB(c,b,d);a.colors.push(e)},f3:function(a,c,b,d,e){a.faces.push(new THREE.Face3(c,b,d,null,a.materials[e]))},f4:function(a,c,b,d,e,g){a.faces.push(new THREE.Face4(c,b,d,e,null,a.materials[g]))},f3n:function(a,c,b,d,e,g,h,j,k){g=a.materials[g];var n=c[j*3],t=c[j*3+1];j=c[j*3+2];var z=c[k*3],v=c[k*3+1];k=c[k*3+2];a.faces.push(new THREE.Face3(b,d,e,[new THREE.Vector3(c[h*3],c[h*3+1],c[h*3+2]),new THREE.Vector3(n,t,j),new THREE.Vector3(z,
v,k)],g))},f4n:function(a,c,b,d,e,g,h,j,k,n,t){h=a.materials[h];var z=c[k*3],v=c[k*3+1];k=c[k*3+2];var o=c[n*3],w=c[n*3+1];n=c[n*3+2];var y=c[t*3],B=c[t*3+1];t=c[t*3+2];a.faces.push(new THREE.Face4(b,d,e,g,[new THREE.Vector3(c[j*3],c[j*3+1],c[j*3+2]),new THREE.Vector3(z,v,k),new THREE.Vector3(o,w,n),new THREE.Vector3(y,B,t)],h))},uv3:function(a,c,b,d,e,g,h){var j=[];j.push(new THREE.UV(c,b));j.push(new THREE.UV(d,e));j.push(new THREE.UV(g,h));a.push(j)},uv4:function(a,c,b,d,e,g,h,j,k){var n=[];n.push(new THREE.UV(c,
b));n.push(new THREE.UV(d,e));n.push(new THREE.UV(g,h));n.push(new THREE.UV(j,k));a.push(n)},init_materials:function(a,c,b){a.materials=[];for(var d=0;d<c.length;++d)a.materials[d]=[THREE.Loader.prototype.createMaterial(c[d],b)]},createMaterial:function(a,c){function b(j){j=Math.log(j)/Math.LN2;return Math.floor(j)==j}function d(j,k){var n=new Image;n.onload=function(){if(!b(this.width)||!b(this.height)){var t=Math.pow(2,Math.round(Math.log(this.width)/Math.LN2)),z=Math.pow(2,Math.round(Math.log(this.height)/
Math.LN2));j.image.width=t;j.image.height=z;j.image.getContext("2d").drawImage(this,0,0,t,z)}else j.image=this;j.needsUpdate=!0};n.src=k}var e,g,h;e="MeshLambertMaterial";g={color:15658734,opacity:1,map:null,lightMap:null,vertexColors:a.vertexColors};a.shading&&a.shading=="Phong"&&(e="MeshPhongMaterial");if(a.mapDiffuse&&c){h=document.createElement("canvas");g.map=new THREE.Texture(h);g.map.sourceFile=a.mapDiffuse;d(g.map,c+"/"+a.mapDiffuse)}else if(a.colorDiffuse){h=(a.colorDiffuse[0]*255<<16)+(a.colorDiffuse[1]*
255<<8)+a.colorDiffuse[2]*255;g.color=h;g.opacity=a.transparency}else if(a.DbgColor)g.color=a.DbgColor;if(a.mapLightmap&&c){h=document.createElement("canvas");g.lightMap=new THREE.Texture(h);g.lightMap.sourceFile=a.mapLightmap;d(g.lightMap,c+"/"+a.mapLightmap)}return new THREE[e](g)},extractUrlbase:function(a){a=a.split("/");a.pop();return a.join("/")}};
